/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teasite;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.web.RpcUrlNode;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teasite.TeasiteBackendTools;
import eu.javaexperience.teavm.url.TeaVmUrlNode;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.AttachDirectoryURLNode;
import eu.javaexperience.web.dispatch.url.JavaClassURLNode;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.dom.build.WebSoftwareBundle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TeasiteBundle
extends JavaClassURLNode {
    public final URLNode resources;
    public final TeaVmUrlNode script;
    public final RpcUrlNode<SimpleRpcRequest, SimpleRpcSession> api;
    protected WebSoftwareBundle[] bundles;
    protected List<String> css = new ArrayList<String>();
    protected List<String> preJs = new ArrayList<String>();
    protected List<String> postJs = new ArrayList<String>();
    protected GetBy1<String, Context> pageId;

    public TeasiteBundle(String name, boolean dev, @MayNull AbstractFile resourcesDir, @MayNull String compileTmpDir, @MayNull AbstractFile scriptFile, @MayNull Class scriptClass, @MayNull WebSoftwareBundle[] bundles, RpcFacility ... rpcFacilities) {
        super(name);
        if (null != resourcesDir) {
            this.resources = new AttachDirectoryURLNode("resources", resourcesDir, dev);
            this.addChild(this.resources);
        } else {
            this.resources = null;
        }
        if (null != scriptClass && null != scriptFile && null != compileTmpDir) {
            this.script = new TeaVmUrlNode(!dev, compileTmpDir, scriptFile, scriptClass);
            this.script.getScriptNode().getRefreshListener().addEventListener(n -> this.refreshBundles());
            this.addChild((URLNode)this.script.getScriptNode());
            this.refreshBundles();
        } else {
            this.script = null;
        }
        if (null != rpcFacilities && 0 != rpcFacilities.length) {
            this.api = RpcUrlNode.createSimple((String)"api", (String)"", (RpcFacility[])rpcFacilities);
            this.addChild((URLNode)this.api);
        } else {
            this.api = null;
        }
        this.bundles = bundles;
    }

    public void setWebSoftwareBundles(WebSoftwareBundle ... sw) {
        this.bundles = sw;
        this.refreshBundles();
    }

    protected void refreshBundles() {
        this.css.clear();
        this.preJs.clear();
        this.postJs.clear();
        if (null != this.bundles) {
            for (WebSoftwareBundle b : this.bundles) {
                List post;
                List pre;
                List c = b.getCss();
                if (null != c) {
                    this.css.addAll(c);
                }
                if (null != (pre = b.getPreJs())) {
                    this.preJs.addAll(pre);
                }
                if (null == (post = b.getPostJs())) continue;
                this.postJs.addAll(this.postJs);
            }
        }
        if (null != this.script) {
            this.postJs.add(FileTools.normalizeSlashes((String)this.script.getScriptNode().getSaltedUrl()));
        }
    }

    public SimplePublish1<Context> asPathDispatch() {
        return ctx -> {
            PreparedURL url = ctx.getRequestUrl();
            url.setPathPointer(url.getDomainElements());
            this.dispatch((Context)ctx);
        };
    }

    protected boolean beforeCall(Context ctx, Method m) {
        return true;
    }

    protected void afterCall(Context ctx, Method m) {
    }

    protected void backward(Context ctx) {
        this.endpoint(ctx);
    }

    protected boolean endpoint(Context ctx) {
        TeasiteBackendTools.renderBootPage(ctx, this.css, this.preJs, this.postJs, null == this.pageId ? null : (String)this.pageId.getBy((Object)ctx));
        return true;
    }

    protected boolean access(Context ctx) {
        return true;
    }
}

