/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.utils;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.jvx.js.lib.ProgressObservable;
import eu.jvx.js.lib.ProgressObserver;
import eu.jvx.js.lib.utils.Task;
import java.util.ArrayList;
import java.util.List;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.jso.browser.Window;

public class BatchTask<R, P>
implements ProgressObservable {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("BatchTask"));
    public SimplePublish1<BatchTask<R, P>> onAllReady;
    public List<Task<R, P>> tasks;
    protected SimplePublish1<Task<R, P>> onSingleTaskDone;
    protected ProgressObserver observer;
    public String name;
    protected Boolean parallelMode;

    public BatchTask(SimplePublish1<BatchTask<R, P>> onReady) {
        this.onAllReady = onReady;
        this.tasks = new ArrayList<Task<R, P>>();
        this.onSingleTaskDone = new SimplePublish1<Task<R, P>>(){

            public void publish(Task<R, P> p1) {
                BatchTask.this.notifyTaskDone(p1);
            }
        };
    }

    public Task<R, P> getUnfinisedTask() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task<R, P> t = this.tasks.get(i);
            if (t.isDone()) continue;
            return t;
        }
        return null;
    }

    public void addTask(SimplePublish2<SimplePublish1<R>, P> cb, P param) {
        if (null != cb) {
            int index = this.tasks.size();
            Task<R, P> t = new Task<R, P>(index, param, cb);
            this.tasks.add(t);
        }
    }

    public void notifyTaskDone(Task<R, P> task) {
        if (null == this.parallelMode) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"Not yet started (with doParallel or doSerial) but task notified that task is ready", (Object[])new Object[0]);
            return;
        }
        if (null != this.observer) {
            this.observer.progress(this, "", task.index, this.tasks.size());
        }
        this.executeNext();
    }

    protected void executeNext() {
        Task<R, P> undone = this.getUnfinisedTask();
        if (!this.parallelMode.booleanValue() && null != undone) {
            undone.execute(this.onSingleTaskDone);
        }
        if (null == undone) {
            if (null != this.observer) {
                this.observer.end(this);
            }
            this.onAllReady.publish((Object)this);
        }
    }

    protected void startTaskAsync(final Task<R, P> t) {
        Window.setTimeout((TimerHandler)new TimerHandler(){

            public void onTimer() {
                t.execute(BatchTask.this.onSingleTaskDone);
            }
        }, (int)0);
    }

    protected void executeAll() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            this.startTaskAsync(this.tasks.get(i));
        }
    }

    public void doParallel(ProgressObserver observer) {
        if (this.tasks.isEmpty()) {
            this.onAllReady.publish((Object)this);
            return;
        }
        this.observer = observer;
        this.parallelMode = true;
        if (null != observer) {
            observer.start(this);
        }
        for (Task<R, P> t : this.tasks) {
            this.startTaskAsync(t);
        }
    }

    public void doSerial(ProgressObserver observer) {
        this.observer = observer;
        this.parallelMode = false;
        if (null != observer) {
            observer.start(this);
        }
        this.executeNext();
    }

    public List<R> getResults() {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this.tasks.size(); ++i) {
            ret.add(this.tasks.get((int)i).result);
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

