/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent;

import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.function.TBiConsumer;
import org.teavm.classlib.java.util.function.TBiFunction;
import org.teavm.classlib.java.util.function.TFunction;

public interface TConcurrentMap<K, V>
extends TMap<K, V> {
    default public V getOrDefault(Object key, V defaultValue) {
        Object v = this.get(key);
        return (V)(v != null ? v : defaultValue);
    }

    default public void forEach(TBiConsumer<? super K, ? super V> action) {
        for (TMap.Entry entry : this.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    public V putIfAbsent(K var1, V var2);

    public boolean remove(Object var1, Object var2);

    public boolean replace(K var1, V var2, V var3);

    public V replace(K var1, V var2);

    default public void replaceAll(TBiFunction<? super K, ? super V, ? extends V> function) {
        this.forEach((k, v) -> {
            while (!this.replace(k, v, function.apply(k, v)) && (v = this.get(k)) != null) {
            }
        });
    }

    default public V computeIfAbsent(K key, TFunction<? super K, ? extends V> mappingFunction) {
        Object newValue;
        Object v = this.get(key);
        return (V)(v == null && (newValue = mappingFunction.apply(key)) != null && (v = this.putIfAbsent(key, newValue)) == null ? newValue : v);
    }

    default public V computeIfPresent(K key, TBiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        while ((oldValue = this.get(key)) != null) {
            Object newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (!this.replace(key, oldValue, newValue)) continue;
                return (V)newValue;
            }
            if (!this.remove(key, oldValue)) continue;
            return null;
        }
        return (V)oldValue;
    }

    default public V compute(K key, TBiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object newValue;
        Object oldValue = this.get(key);
        while (true) {
            if ((newValue = remappingFunction.apply(key, oldValue)) == null) {
                if (oldValue != null || this.containsKey(key)) {
                    if (this.remove(key, oldValue)) {
                        return null;
                    }
                    oldValue = this.get(key);
                    continue;
                }
                return null;
            }
            if (oldValue != null) {
                if (this.replace(key, oldValue, newValue)) {
                    return (V)newValue;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, newValue);
            if (oldValue == null) break;
        }
        return (V)newValue;
    }

    default public V merge(K key, V value, TBiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object oldValue = this.get(key);
        while (true) {
            if (oldValue != null) {
                Object newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (this.replace(key, oldValue, newValue)) {
                        return (V)newValue;
                    }
                } else if (this.remove(key, oldValue)) {
                    return null;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, value);
            if (oldValue == null) break;
        }
        return value;
    }
}

