/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.container.impl;

import eu.jvx.js.lib.HtmlContainer;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.bindings.VanillaTools;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.css.CSSStyleDeclaration;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class SimpleRowStackContainer
implements HtmlContainer {
    protected HTMLElement root = VanillaTools.inlineCreateElement("div", new String[0]);
    protected double spacingBetween = 0.0;
    protected double spacingBeforeAfter = 0.0;

    public SimpleRowStackContainer() {
        ImpTools.appendImp(this.root, this);
    }

    public void addNode(HTMLElement node) {
        this.root.appendChild((Node)node);
        this.updateBoxWidths();
    }

    public void updateBoxWidths() {
        JSArray<HTMLElement> ch = this.getSubNodes();
        if (0 == ch.getLength()) {
            return;
        }
        double width = 1.0;
        width -= 2.0 * this.spacingBeforeAfter;
        int num = ch.getLength() - 1;
        width -= (double)num * this.spacingBetween;
        width /= (double)ch.getLength();
        String w = (width *= 100.0) + "%";
        String s = this.spacingBetween * 100.0 + "%";
        for (int i = 0; i < ch.getLength(); ++i) {
            HTMLElement n = (HTMLElement)ch.get(i);
            CSSStyleDeclaration style = n.getStyle();
            style.setPropertyValue("marginLeft", s);
            style.setPropertyValue("marginRight", s);
            style.setProperty("display", "inline-block");
            style.setProperty("width", w);
            if (0 == i) {
                style.setPropertyValue("marginLeft", this.spacingBeforeAfter * 100.0 + "%");
            }
            if (0 != ch.getLength() - 1) continue;
            style.setPropertyValue("marginRight", this.spacingBeforeAfter * 100.0 + "%");
        }
    }

    public JSArray<HTMLElement> getSubNodes() {
        return VanillaTools.getChildren(this.root);
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    public HTMLElement getHtml() {
        return this.root;
    }

    public void setSpacingBeforeAfter(double d, boolean update) {
        this.spacingBeforeAfter = d;
        if (update) {
            this.updateBoxWidths();
        }
    }

    public void setSpacingBetween(double d, boolean update) {
        this.spacingBetween = d;
        if (update) {
            this.updateBoxWidths();
        }
    }
}

