/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.trigger;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.jvx.js.lib.bindings.VanillaTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.json.JSON;

public class TriggerRegistry {
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("TriggerRegistry"));
    protected String namespace;
    protected Map<String, SimplePublish1<DataObject>> triggers = new HashMap<String, SimplePublish1<DataObject>>();
    protected Map<String, SimplePublish1<DataObject>> ro = Collections.unmodifiableMap(this.triggers);
    protected EventListener<Event> listener = new EventListener<Event>(){

        public void handleEvent(Event e) {
            DataObjectTeaVMImpl det = new DataObjectTeaVMImpl(((VanillaTools.EtcNodeSupport)e).getDetail());
            String name = det.getString("name");
            if (null != name) {
                SimplePublish1<DataObject> call = TriggerRegistry.this.triggers.get(name);
                if (null != call) {
                    call.publish((Object)det);
                } else {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"TeaVm trigger not found: %s", (Object)name);
                }
            } else {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"No name specified in TeaVm trigger (CustomEvent.detail.name). CustomEvent.detail: %s", (Object)JSON.stringify((JSObject)((JSObject)det.getImpl())));
            }
        }
    };

    public void registerTrigger(String name, SimplePublish1<DataObject> handler) {
        if (this.triggers.containsKey(name)) {
            throw new RuntimeException("Trigger already exists: " + name);
        }
        this.triggers.put(name, handler);
    }

    public void removeTrigger(String name) {
        this.triggers.remove(name);
    }

    public Map<String, SimplePublish1<DataObject>> getTriggersRo() {
        return this.ro;
    }

    public TriggerRegistry() {
        VanillaTools.getDom().addEventListener(this.namespace, this.listener);
    }

    public void uninstall() {
        VanillaTools.getDom().removeEventListener(this.namespace, this.listener);
    }
}

