/*
 * Decompiled with CFR 0.152.
 */
package eu.teasite.frontend.api;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.semantic.references.MayNull;
import eu.teasite.frontend.api.ApiTransaction;
import eu.teasite.frontend.api.ApiTransactionCollector;
import eu.teasite.frontend.api.ServerEvent;
import eu.teasite.frontend.api.transfers.AjaxTransfer;
import eu.teasite.frontend.api.transfers.ApiPacketTransfer;

public class ApiClient
extends ApiTransaction {
    protected String apiStartUrl;
    protected EventMediator<ServerEvent> serverEvents = new EventMediator();

    public ApiClient(String startUrl, boolean websocket) {
        super(websocket ? null : new AjaxTransfer(startUrl + "/ajax"));
        this.apiStartUrl = startUrl;
    }

    public ApiClient(ApiPacketTransfer transfer) {
        super(transfer);
        this.apiStartUrl = "";
    }

    public EventMediator<ServerEvent> getServerEventManager() {
        return this.serverEvents;
    }

    public ApiTransaction startTransaction() {
        return new ApiTransactionCollector(this);
    }

    @Override
    protected ApiPacketTransfer wrapTransfer(Class cls, ApiPacketTransfer transfer) {
        return transfer;
    }

    @Override
    public void commit(@MayNull SimpleCall onDone) {
    }

    public static ApiClient connectTeasiteDefault(boolean websocket) {
        return new ApiClient("/site_api", websocket);
    }
}

