/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.activity;

import eu.javaexperience.patterns.creational.builder.PublisherBuilderTools;
import eu.javaexperience.teasite.frontend.tools.TeasiteFrontendTools;
import eu.javaexperience.teavm.templatesite.common.PageStorage;
import eu.jvx.js.lib.SimpleWrapperHtml;
import eu.jvx.js.lib.WrapperHtml;
import eu.jvx.js.lib.activity.AbstractPageStarter;
import eu.jvx.js.lib.activity.StartablePageId;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.tbs.ui.TbsLayoutTools;
import java.util.ArrayList;
import java.util.Collection;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;

public class DefaultPageStarter<P extends StartablePageId>
extends AbstractPageStarter<P> {
    protected String siteTitle;

    public DefaultPageStarter(PageStorage<P> storage, String siteTitle) {
        super(storage);
        this.siteTitle = siteTitle;
        this.getResettedContainer();
    }

    protected boolean startDefaultActivity() {
        HTMLElement el = Window.current().getDocument().querySelector(".page_identifier_data");
        return null != el && this.tryStartActivity(el.getAttribute("data-page_id"));
    }

    protected boolean tryStartActivity(String act) {
        StartablePageId activity;
        if (null != act && null != (activity = (StartablePageId)this.pageStorage.getById(act))) {
            this.startPage(activity);
            return true;
        }
        return false;
    }

    @Override
    protected WrapperHtml initPage() {
        HTMLElement mainFrame;
        HTMLElement contentContainer = H.H("div").attrs("id", "content_container", "class", "well").getHtml();
        VanillaTools.addToHeader(H.H("meta", "content", "width=device-width, initial-scale=1.0", "name", "viewport").getHtml());
        H.H((HTMLElement)Window.current().getDocument().getBody()).addChilds(H.H("div").attrs("class", "container").addChilds(H.H("div").attrs("class", "row").addChilds(mainFrame = H.H("div").attrs("id", "site_mainframe").addChilds(new JSObject[]{null == this.siteTitle ? null : H.H("div").attrs("class", "alert alert-success text-center", "role", "alert").addChilds(H.H("h1").attrs("#text", this.siteTitle)), H.H("header").attrs("class", "alert").addChilds(this.renderNav()), contentContainer}).getHtml())));
        return new SimpleWrapperHtml((Element)mainFrame, (Element)contentContainer);
    }

    public Collection<HTMLElement> getLinks() {
        ArrayList<HTMLElement> ret = new ArrayList<HTMLElement>();
        for (StartablePageId p : (StartablePageId[])this.pageStorage.getPages()) {
            ret.add(TeasiteFrontendTools.createActivityLink(p, p.getLabel(), "btn btn-default"));
        }
        return ret;
    }

    protected HTMLElement renderNav() {
        return (HTMLElement)PublisherBuilderTools.buildAll(TbsLayoutTools.buildHorizontalPills(), null, this.getLinks());
    }
}

