/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.ui;

import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.FrontendTools;
import java.util.ArrayList;
import java.util.List;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.jso.browser.Window;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.css.CSSStyleDeclaration;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.EventTarget;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLBodyElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.html.TextRectangle;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public class Autocomplete<T> {
    protected AutocompleteSettings<T> options;
    protected List<AutocompleteElement> elems;

    public Autocomplete(AutocompleteSettings<T> settings) {
        this.options = settings;
        this.initalize();
    }

    protected void initalize() {
        if (null == this.elems) {
            ArrayList<HTMLElement> es = new ArrayList<HTMLElement>();
            if (null != this.options.target) {
                es.add((HTMLElement)this.options.target);
            }
            if (null != this.options.selector) {
                NodeList els = Window.current().getDocument().querySelectorAll(this.options.selector);
                VanillaTools.copyTo((NodeList<? extends HTMLElement>)els, es);
            }
            ArrayList<AutocompleteElement> aes = new ArrayList<AutocompleteElement>();
            for (HTMLElement e : es) {
                aes.add(new AutocompleteElement(e));
            }
            this.elems = aes;
        }
    }

    protected static void addEvent(EventTarget el, String type, EventListener<? extends Event> handler) {
        el.addEventListener(type, FrontendTools.wrapProcessEventWithThread(handler), true);
    }

    protected static void live(final String elClass, String event, final EventListener<Event> cb, EventTarget context) {
        if (null == context) {
            context = Window.current().getDocument().getBody();
        }
        Autocomplete.addEvent(context, event, (EventListener<? extends Event>)new EventListener<Event>(){

            public void handleEvent(Event e) {
                boolean found = false;
                HTMLDocument doc = Window.current().getDocument();
                for (HTMLElement el = (HTMLElement)e.getTarget(); null != el && el != doc; el = (HTMLElement)el.getParentNode()) {
                    found = Autocomplete.hasClass(el, elClass);
                    if (!found) continue;
                    cb.handleEvent(e);
                    return;
                }
            }
        });
    }

    protected static boolean hasClass(HTMLElement elem, String className) {
        if (null == elem) {
            return false;
        }
        VanillaTools.ClassList cl = VanillaTools.getClassList(elem);
        if (null == cl) {
            return false;
        }
        return cl.contains(className);
    }

    public void destroy() {
        for (AutocompleteElement elem : this.elems) {
            elem.destroy();
        }
    }

    static {
        VanillaTools.addCssRule(".autocomplete-suggestions {\n\t\t    text-align: left; cursor: default; border: 1px solid #ccc; border-top: 0; background: #fff; box-shadow: -1px 1px 3px rgba(0,0,0,.1);\n\n\t\t    position: absolute; display: none; z-index: 9999; max-height: 254px; overflow: hidden; overflow-y: auto; box-sizing: border-box;\n\t\t}\n");
        VanillaTools.addCssRule(".autocomplete-suggestion { position: relative; padding: 0 .6em; line-height: 23px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; font-size: 1.02em; color: #333; }");
        VanillaTools.addCssRule(".autocomplete-suggestion b { font-weight: normal; color: #1f8dd6; }");
        VanillaTools.addCssRule(".autocomplete-suggestion.selected { background: #f0f0f0; }");
    }

    protected class AutocompleteElement {
        protected HTMLInputElement targetElement;
        protected HTMLElement sc;
        protected String autocompleteAttr;
        protected String last_val;
        protected EventListener<Event> updateSC;
        protected EventListener<Event> blurHandler;
        protected EventListener<KeyboardEvent> keydownHandler;
        protected EventListener<KeyboardEvent> keyupHandler;
        protected EventListener<Event> focusHandler;
        protected int timer;

        public AutocompleteElement(HTMLElement target) {
            this.targetElement = (HTMLInputElement)target;
            this.initalize();
        }

        protected void initalize() {
            final HTMLDocument document = Window.current().getDocument();
            HTMLBodyElement body = Window.current().getDocument().getBody();
            Window window = Window.current();
            this.sc = VanillaTools.inlineCreateElement("div", new String[0]);
            this.sc.setClassName("autocomplete-suggestions " + Autocomplete.this.options.menuClass);
            this.autocompleteAttr = this.targetElement.getAttribute("autocomplete");
            this.targetElement.setAttribute("autocomplete", "off");
            this.last_val = "";
            this.updateSC = new EventListener<Event>((HTMLElement)body){
                final /* synthetic */ HTMLElement val$body;
                {
                    this.val$body = hTMLElement;
                }

                public void handleEvent(Event resize) {
                    TextRectangle rect = AutocompleteElement.this.targetElement.getBoundingClientRect();
                    CSSStyleDeclaration style = AutocompleteElement.this.sc.getStyle();
                    int pox = -this.val$body.getBoundingClientRect().getLeft();
                    int poy = -this.val$body.getBoundingClientRect().getTop();
                    style.setProperty("left", rect.getLeft() + pox + Autocomplete.this.options.offsetLeft + "px");
                    style.setProperty("top", rect.getBottom() + poy + Autocomplete.this.options.offsetTop + "px");
                    style.setProperty("display", "block");
                    if (null == style.getPropertyValue("maxHeight")) {
                        style.setProperty("maxHeight", "250px");
                    }
                    if (null != style.getPropertyValue("suggestionHeight")) {
                        HTMLElement next = AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion.selected");
                        if (null == next) {
                            style.setProperty("scrollTop", "0");
                        } else {
                            int scrTop = AutocompleteElement.this.sc.getScrollTop();
                            int selTop = next.getBoundingClientRect().getTop() - AutocompleteElement.this.sc.getBoundingClientRect().getTop();
                            if (selTop < 0) {
                                AutocompleteElement.this.sc.setScrollTop(selTop + scrTop);
                            }
                        }
                    }
                }
            };
            Autocomplete.addEvent((EventTarget)window, "resize", this.updateSC);
            body.appendChild((Node)this.sc);
            Autocomplete.live("autocomplete-suggestion", "mouseleave", new EventListener<Event>(){

                public void handleEvent(Event arg0) {
                    final HTMLElement sel = AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion.selected");
                    if (null != sel) {
                        Window.setTimeout((TimerHandler)new TimerHandler(){

                            public void onTimer() {
                                VanillaTools.getClassList(sel).remove("selected");
                            }
                        }, (int)20);
                    }
                }
            }, (EventTarget)this.sc);
            Autocomplete.live("autocomplete-suggestion", "mouseover", new EventListener<Event>(){

                public void handleEvent(Event arg0) {
                    HTMLElement elem;
                    HTMLElement sel = AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion.selected");
                    if (null != sel) {
                        VanillaTools.getClassList(sel).remove("selected");
                    }
                    if (null != (elem = VanillaTools.whereParentOrThis((HTMLElement)arg0.getTarget().cast(), ".autocomplete-suggestion"))) {
                        VanillaTools.getClassList(elem).add("selected");
                    }
                }
            }, (EventTarget)this.sc);
            Autocomplete.live("autocomplete-suggestion", "mousedown", new EventListener<Event>(){

                public void handleEvent(Event e) {
                    HTMLElement elem = VanillaTools.whereParentOrThis((HTMLElement)e.getTarget().cast(), ".autocomplete-suggestion");
                    if (null != elem) {
                        String v = elem.getAttribute("data-val");
                        AutocompleteElement.this.targetElement.setValue(v);
                        Autocomplete.this.options.onSelect.publish((Object)e, (Object)v, (Object)AutocompleteElement.this.targetElement);
                        AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                    }
                }
            }, (EventTarget)this.sc);
            this.blurHandler = new EventListener<Event>(){

                public void handleEvent(Event arg0) {
                    HTMLElement over_sb = null;
                    try {
                        over_sb = document.querySelector(".autocomplete-suggestions");
                    }
                    catch (Exception e) {
                        over_sb = null;
                    }
                    System.out.println("blur: " + (null == over_sb ? null : VanillaTools.getDomPath(over_sb)));
                    if (null != over_sb) {
                        AutocompleteElement.this.last_val = AutocompleteElement.this.targetElement.getValue();
                        AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                        Window.setTimeout((TimerHandler)new TimerHandler(){

                            public void onTimer() {
                                AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                            }
                        }, (int)350);
                    }
                }
            };
            Autocomplete.addEvent((EventTarget)this.targetElement, "blur", this.blurHandler);
            final SimplePublish1 suggest = new SimplePublish1<List<T>>(){

                public void publish(List<T> data) {
                    String val = AutocompleteElement.this.targetElement.getValue();
                    if (data.size() > 0 && val.length() >= Autocomplete.this.options.minChars) {
                        AutocompleteElement.this.sc.clear();
                        for (int i = 0; i < data.size(); ++i) {
                            AutocompleteElement.this.sc.appendChild((Node)Autocomplete.this.options.renderItem.getBy(data.get(i), (Object)val));
                        }
                        AutocompleteElement.this.updateSC.handleEvent(null);
                    } else {
                        AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                    }
                }
            };
            this.keydownHandler = new EventListener<KeyboardEvent>(){

                public void handleEvent(KeyboardEvent e) {
                    HTMLElement sel;
                    int key = e.getKeyCode();
                    if (!(key != 40 && key != 38 || StringTools.isNullOrEmpty((String)AutocompleteElement.this.sc.getInnerHTML()))) {
                        HTMLElement next = null;
                        HTMLElement sel2 = AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion.selected");
                        if (null == sel2) {
                            JSArray<HTMLElement> lst = VanillaTools.getChildNodes(AutocompleteElement.this.sc);
                            next = key == 40 ? AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion") : (HTMLElement)lst.get(lst.getLength() - 1);
                            VanillaTools.getClassList(next).add("selected");
                            AutocompleteElement.this.targetElement.setValue(next.getAttribute("data-val"));
                        } else {
                            next = (HTMLElement)(key == 40 ? sel2.getNextSibling() : sel2.getPreviousSibling());
                            if (null != next) {
                                VanillaTools.getClassList(sel2).remove("selected");
                                VanillaTools.getClassList(next).add("selected");
                                AutocompleteElement.this.targetElement.setValue(next.getAttribute("data-val"));
                            } else {
                                VanillaTools.getClassList(sel2).remove("selected");
                                AutocompleteElement.this.targetElement.setValue(AutocompleteElement.this.last_val);
                                next = null;
                            }
                        }
                        AutocompleteElement.this.updateSC.handleEvent(null);
                        return;
                    }
                    if (key == 27) {
                        AutocompleteElement.this.targetElement.setValue(AutocompleteElement.this.last_val);
                        AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                    } else if (!(key != 13 && key != 9 || null == (sel = AutocompleteElement.this.sc.querySelector(".autocomplete-suggestion.selected")) || AutocompleteElement.this.sc.getStyle().getPropertyValue("display").equals("none"))) {
                        Autocomplete.this.options.onSelect.publish((Object)e, (Object)sel.getAttribute("data-val"), (Object)sel);
                        Window.setTimeout((TimerHandler)new TimerHandler(){

                            public void onTimer() {
                                AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                            }
                        }, (int)20);
                    }
                }
            };
            Autocomplete.addEvent((EventTarget)this.targetElement, "keydown", this.keydownHandler);
            this.keyupHandler = new EventListener<KeyboardEvent>(){

                public void handleEvent(KeyboardEvent event) {
                    int key = event.getKeyCode();
                    if ((key < 35 || key > 40) && key != 13 && key != 9 && key != 27) {
                        final String val = AutocompleteElement.this.targetElement.getValue();
                        if (val.length() >= Autocomplete.this.options.minChars) {
                            if (!val.equals(AutocompleteElement.this.last_val)) {
                                AutocompleteElement.this.last_val = val;
                                Window.clearTimeout((int)AutocompleteElement.this.timer);
                                AutocompleteElement.this.timer = Window.setTimeout((TimerHandler)new TimerHandler(){

                                    public void onTimer() {
                                        new Thread(){

                                            @Override
                                            public void run() {
                                                Autocomplete.this.options.source.publish((Object)val, (Object)suggest);
                                            }
                                        }.start();
                                    }
                                }, (int)Autocomplete.this.options.delay);
                            }
                        } else {
                            AutocompleteElement.this.last_val = val;
                            AutocompleteElement.this.sc.getStyle().setProperty("display", "none");
                        }
                    }
                }
            };
            Autocomplete.addEvent((EventTarget)this.targetElement, "keyup", this.keyupHandler);
            this.focusHandler = new EventListener<Event>(){

                public void handleEvent(Event e) {
                    AutocompleteElement.this.last_val = "\n";
                    AutocompleteElement.this.keyupHandler.handleEvent((Event)((KeyboardEvent)e));
                }
            };
            if (Autocomplete.this.options.minChars > 0) {
                Autocomplete.addEvent((EventTarget)this.targetElement, "focus", this.focusHandler);
            }
        }

        public void destroy() {
            Window window = Window.current();
            if (null != this.autocompleteAttr) {
                this.targetElement.setAttribute("autocomplete", this.autocompleteAttr);
            } else {
                this.targetElement.removeAttribute("autocomplete");
            }
            window.getDocument().getBody().removeChild((Node)this.sc);
        }
    }

    public static class AutocompleteSettings<T> {
        public HTMLInputElement target;
        public String selector = null;
        public int minChars = 3;
        public int delay = 150;
        public int offsetLeft = 0;
        public int offsetTop = 1;
        public String menuClass = "";
        public SimplePublish3<Event, String, HTMLElement> onSelect;
        public SimplePublish2<String, SimplePublish1<List<T>>> source;
        public GetBy2<HTMLElement, T, String> renderItem = DEFAULT_ITEM_RENDERER;
        public static final GetBy2<HTMLElement, Object, String> DEFAULT_ITEM_RENDERER = new GetBy2<HTMLElement, Object, String>(){

            public HTMLElement getBy(Object item, String search) {
                String i = String.valueOf(item);
                return new H("div").attrs("class", "autocomplete-suggestion", "data-val", i, "#text", i).getHtml();
            }
        };

        public AutocompleteSettings(String selector, SimplePublish2<String, SimplePublish1<List<T>>> source, SimplePublish3<Event, String, HTMLElement> onSelect) {
            this.selector = selector;
            this.source = source;
            this.onSelect = onSelect;
        }

        public AutocompleteSettings(HTMLElement elem, SimplePublish2<String, SimplePublish1<List<T>>> source, SimplePublish3<Event, String, HTMLElement> onSelect) {
            this.target = (HTMLInputElement)elem;
            this.source = source;
            this.onSelect = onSelect;
        }
    }
}

