/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teasite.frontend.tools;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teavm.templatesite.common.PageId;
import eu.javaexperience.teavm.templatesite.common.PageStorage;
import eu.javaexperience.teavm.templatesite.frontend.PageStarter;
import eu.jvx.js.lib.HtmlActivity;
import eu.jvx.js.lib.activity.AbstractPageStarter;
import eu.jvx.js.lib.activity.StartablePageId;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.history.HistoryTools;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;

public class TeasiteFrontendTools {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("TeasiteFrontendTools"));
    protected static AbstractPageStarter INFRASTRUCTURE_PAGE_STARTER = null;

    public static void registerInfrastructurePageStater(AbstractPageStarter starter) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"registerInfrastructurePageStater: %s", (Object)starter);
        INFRASTRUCTURE_PAGE_STARTER = starter;
    }

    public static AbstractPageStarter getInfrastructurePageStater() {
        return INFRASTRUCTURE_PAGE_STARTER;
    }

    public static <T extends StartablePageId> void addActivityHistoryBackListener(final PageStorage<T> storage, final PageStarter<T> starter) {
        Window.current().addEventListener("popstate", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event e) {
                TeasiteFrontendTools.actualisePage(storage, starter);
            }
        });
    }

    protected static <T extends StartablePageId> void actualisePage(PageStorage<? extends T> storage, PageStarter<T> starter) {
        String path = HistoryTools.getPath();
        StartablePageId id = (StartablePageId)storage.getByUrl(path);
        StartablePageId cp = (StartablePageId)starter.getCurrentPage();
        HtmlActivity ca = starter.getCurrentActivity();
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"actualisePage: id: %s, cp: %s, ca: %s", (Object)id, (Object)cp, (Object)ca);
        if (null != id) {
            if (null != cp && null != ca && id.equals(cp)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"actualizing page: reload %s", (Object)id);
                ca.reload();
            } else {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"actualizing page: start new %s", (Object)id);
                starter.startPage(id);
            }
        }
    }

    public static <T extends StartablePageId> void addActivityStarterListener(HTMLElement ROOT, final PageStorage<T> storage, final PageStarter<T> starter) {
        ROOT.addEventListener("click", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event e) {
                HTMLElement tar = (HTMLElement)e.getTarget();
                if (VanillaTools.getClassList(tar).contains("teavm_onpage_activity_link")) {
                    e.stopPropagation();
                    e.preventDefault();
                    String id = tar.getAttribute("data-onpage_activity");
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"ActivityStarterListener - activity: %s", (Object)id);
                    if (null != id) {
                        StartablePageId pid = (StartablePageId)storage.getById(id);
                        if (null != pid) {
                            HistoryTools.pushUrl(pid.url());
                            TeasiteFrontendTools.actualisePage(storage, starter);
                            return;
                        }
                        Window.current();
                        Window.alert((String)("Unrecognisable activity: " + id));
                    } else {
                        Window.current();
                        Window.alert((String)"No activity specified by the link");
                    }
                }
            }
        });
    }

    public static HTMLElement createActivityLink(PageId page, String label, @MayNull String cssClasses) {
        return VanillaTools.inlineCreateElement("a", "#text", label, "href", "#", "class", "teavm_onpage_activity_link" + (null == cssClasses ? "" : " " + cssClasses), "data-onpage_activity", page.getId());
    }
}

