/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.resource;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.resource.FrontendResource;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLHeadElement;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public class FrontendResourceTools {
    protected static final GetBy1<HTMLElement, String> CREATE_CSS = new GetBy1<HTMLElement, String>(){

        public HTMLElement getBy(String url) {
            return VanillaTools.inlineCreateElement("link", "rel", "stylesheet", "href", url);
        }
    };
    protected static final GetBy1<HTMLElement, String> CREATE_JS = new GetBy1<HTMLElement, String>(){

        public HTMLElement getBy(String url) {
            return VanillaTools.inlineCreateElement("script", "type", "text/javascript", "src", url);
        }
    };
    public static final SimplePublish2<SimplePublish1<FrontendResource>, FrontendResource> ENSURE_RESOURCE = new SimplePublish2<SimplePublish1<FrontendResource>, FrontendResource>(){

        public void publish(final SimplePublish1<FrontendResource> a, final FrontendResource b) {
            FrontendResourceTools.requireResource(b, new SimpleCall(){

                public void call() {
                    a.publish((Object)b);
                }
            });
        }
    };

    public static void requireResource(FrontendResource resource, SimpleCall onReady) {
        switch (resource.type) {
            case CSS: {
                FrontendResourceTools.ensureHeadResource("link[rel='stylesheet']", "href", resource.url, CREATE_CSS, onReady);
                return;
            }
            case JAVASCRIPT: {
                FrontendResourceTools.ensureHeadResource("script[type='text/javascript']", "src", resource.url, CREATE_JS, onReady);
                return;
            }
        }
        throw new UnimplementedCaseException((Enum)resource.type);
    }

    public static void ensureHeadResource(String selector, String attr, String url, GetBy1<HTMLElement, String> nodeCreator, final SimpleCall onReady) {
        NodeList lnks = Window.current().getDocument().querySelectorAll(selector);
        for (int i = 0; i < lnks.getLength(); ++i) {
            if (!url.equals(((HTMLElement)lnks.get(i)).getAttribute(attr))) continue;
            if (null != onReady) {
                onReady.call();
            }
            return;
        }
        HTMLElement elem = (HTMLElement)nodeCreator.getBy((Object)url);
        if (null != onReady) {
            elem.listenLoad((EventListener)new EventListener<Event>(){

                public void handleEvent(Event arg0) {
                    onReady.call();
                }
            });
        }
        FrontendResourceTools.getOrCreateHead().appendChild((Node)elem);
    }

    public static HTMLElement getOrCreateHead() {
        HTMLHeadElement head = Window.current().getDocument().getHead();
        if (null == head) {
            head = VanillaTools.inlineCreateElement("head", new String[0]);
            Window.current().getDocument().appendChild((Node)head);
        }
        return head;
    }
}

