/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.style;

import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleClassSource;
import eu.jvx.js.lib.style.StyleDecorator;
import eu.jvx.js.lib.style.StyleMenuSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.jso.dom.html.HTMLElement;

public class StyleAlaCarteMenu
implements StyleMenuSource,
StyleDecorator {
    protected List<String> classes;

    public StyleAlaCarteMenu(String ... classes) {
        ArrayList<String> proc = new ArrayList<String>();
        for (String s : classes) {
            if (null == s) continue;
            proc.add(s);
        }
        this.classes = Collections.unmodifiableList(proc);
    }

    public StyleAlaCarteMenu(StyleClassSource ... classes) {
        ArrayList<String> proc = new ArrayList<String>();
        for (StyleClassSource s : classes) {
            if (null == s) continue;
            proc.add(s.getCssClassName());
        }
        this.classes = Collections.unmodifiableList(proc);
    }

    @Override
    public void setStyle(HTMLElement elem, boolean trueSet_falseRemove) {
        VanillaTools.ClassList cl = VanillaTools.getClassList(elem);
        for (String cls : this.classes) {
            if (trueSet_falseRemove) {
                cl.add(cls);
                continue;
            }
            cl.remove(cls);
        }
    }

    public void setStyle(HTMLElement elem) {
        this.setStyle(elem, true);
    }

    public void unsetStyle(HTMLElement elem) {
        this.setStyle(elem, false);
    }

    @Override
    public boolean hasAll(HTMLElement elem) {
        VanillaTools.ClassList cl = VanillaTools.getClassList(elem);
        for (String cls : this.classes) {
            if (cl.contains(cls)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAny(HTMLElement elem) {
        VanillaTools.ClassList cl = VanillaTools.getClassList(elem);
        for (String cls : this.classes) {
            if (!cl.contains(cls)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toggleStyles(HTMLElement elem) {
        this.setStyle(elem, !this.hasAll(elem));
    }

    @Override
    public List<String> getClassNames() {
        return this.classes;
    }
}

