/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teavm.datareprez;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.convertFrom.DataReprezComponentTypes;
import eu.javaexperience.io.primitive.LineReader;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.teavm.datareprez.DataArrayTeaVMImpl;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.jvx.js.lib.teavm.NativeJsSupportTeaVM;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSBoolean;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSString;
import org.teavm.jso.json.JSON;

public class DataProtocolTeaVMImpl
implements DataProtocol {
    public static final DataProtocolTeaVMImpl intance = new DataProtocolTeaVMImpl();

    public byte[] acquirePacket(InputStream is) throws IOException {
        return LineReader.readByteLine((InputStream)is, (LineReader.LineMode)LineReader.LineMode.Unix);
    }

    public void sendPacket(byte[] data, OutputStream os) throws IOException {
        os.write(data);
        os.write(10);
    }

    public DataObject newObjectInstance() {
        return new DataObjectTeaVMImpl();
    }

    public DataArray newArrayInstance() {
        return new DataArrayTeaVMImpl();
    }

    public DataObject objectFromBlob(byte[] data) {
        return new DataObjectTeaVMImpl(JSON.parse((String)new String(data)));
    }

    public DataArray arrayFromBlob(byte[] data) {
        return new DataArrayTeaVMImpl((JSArray<JSObject>)((JSArray)JSON.parse((String)new String(data))));
    }

    public static JSObject castToNative(Class cls, Object o) {
        if (null != o) {
            DataReprezComponentTypes type = DataReprezComponentTypes.recognise((Class)cls);
            if (null != type) {
                switch (type) {
                    case Boolean: {
                        return JSBoolean.valueOf((boolean)((Boolean)CastTo.Boolean.cast(o)));
                    }
                    case DataArray: {
                        return ((DataArrayTeaVMImpl)((Object)o)).array;
                    }
                    case DataObject: {
                        return ((DataObjectTeaVMImpl)((Object)o)).obj;
                    }
                    case Double: {
                        return JSNumber.valueOf((double)((Double)CastTo.Double.cast(o)));
                    }
                    case Integer: {
                        return JSNumber.valueOf((int)((Integer)CastTo.Int.cast(o)));
                    }
                    case Long: {
                        return JSNumber.valueOf((float)((Long)CastTo.Long.cast(o)).longValue());
                    }
                    case NULL: {
                        return null;
                    }
                    case String: {
                        return JSString.valueOf((String)((String)CastTo.String.cast(o)));
                    }
                }
            }
            throw new RuntimeException("Unrecognised class type: " + cls);
        }
        return null;
    }

    public static Object castFromNative(Class cls, JSObject o) {
        Object rec = DataProtocolTeaVMImpl.receiveObject(o);
        if (null == cls) {
            return rec;
        }
        return CastTo.getCasterForTargetClass((Class)cls).cast(rec);
    }

    protected static Object receiveObject(JSObject o) {
        if (null != o) {
            String jt;
            switch (jt = ((NativeJsSupportTeaVM.Direct)o).getClassType()) {
                case "Number": {
                    JSNumber num = (JSNumber)o;
                    double d = num.doubleValue();
                    if (Math.floor(d) == d) {
                        return (long)d;
                    }
                    return d;
                }
                case "Array": {
                    return new DataArrayTeaVMImpl((JSArray<JSObject>)((JSArray)o));
                }
                case "Boolean": {
                    return ((JSBoolean)o).booleanValue();
                }
                case "String": {
                    return ((JSString)o).stringValue();
                }
                case "jl_String": {
                    return (String)o;
                }
                case "jl_Integer": {
                    return (Integer)o;
                }
                case "jl_Boolean": {
                    return (Boolean)o;
                }
                case "jl_Long": {
                    return (Long)o;
                }
                case "jl_Double": {
                    return (Double)o;
                }
            }
            return new DataObjectTeaVMImpl(o);
        }
        return null;
    }

    public Class getCommonsClass() {
        return JSObject.class;
    }
}

