/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.logging;

import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import java.util.ArrayList;
import java.util.HashSet;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.events.MouseEvent;
import org.teavm.jso.dom.html.HTMLElement;

public class LoggingSettings {
    protected static boolean KEY_BOUND = false;

    public static H createLogLevelChooser() {
        H ret = new H("select").attrs("style", "margin:6px");
        for (LogLevel l : LogLevel.values()) {
            ret.addChilds(new H("option").attrs("#text", l.name(), "value", l.name()));
        }
        return ret;
    }

    public static void openLoggingSettings() {
        Window w = Window.current().open("", "", "width=400,height=500");
        HtmlTools.setPageTitle(w.getDocument(), "Javaexperience logging facility settings");
        H b = new H((HTMLElement)w.getDocument().getBody());
        H loggersContainer = new H("div");
        HashSet added = new HashSet();
        ArrayList regLoggers = new ArrayList();
        H refresh = new H("button").attrs("#text", "Refresh list of loggers").on("click", (EventListener<Event>)((EventListener)e -> {
            ArrayList loggers = new ArrayList();
            JavaExperienceLoggingFacility.listIssuedLoggers(loggers);
            for (Logger l : loggers) {
                if (!added.add(l)) continue;
                LoggerSettings ls = new LoggerSettings(l);
                regLoggers.add(ls);
                loggersContainer.addChilds(ls.root);
            }
        }));
        H setAllLevel = new H("div");
        H level = LoggingSettings.createLogLevelChooser();
        LoggingDetailLevel ll = JavaExperienceLoggingFacility.getDefaultLogLevel();
        VanillaTools.setContent(level.getHtml(), ll.getLabel());
        setAllLevel.addChilds(new H("span").attrs("#text", "Set all to level:"), level, new H("button").attrs("#text", "Set").onClick((EventListener<MouseEvent>)((EventListener)e -> {
            String cnt = VanillaTools.getContent(level.getHtml());
            LogLevel lvl = (LogLevel)EnumTools.recogniseSymbol(LogLevel.class, (Object)cnt);
            if (null != lvl) {
                JavaExperienceLoggingFacility.setAllFacilityLoglevel((LogLevel)lvl);
                JavaExperienceLoggingFacility.setFutureDefaultLoglevel((LoggingDetailLevel)lvl);
                for (LoggerSettings l : regLoggers) {
                    l.setLevel(lvl);
                }
            }
        })));
        b.addChilds(new H("h4").attrs("#text", "List of loggers"), new H("br"), loggersContainer, new H("div").addChilds(refresh), setAllLevel);
        refresh.getHtml().click();
    }

    public static void boundLoggingSettingsHotkeyCtrlShiftL() {
        if (!KEY_BOUND) {
            KEY_BOUND = true;
            new H((HTMLElement)VanillaTools.getDom()).on("keyup", (EventListener<Event>)((EventListener)e -> {
                KeyboardEvent ke = (KeyboardEvent)e;
                if (ke.isCtrlKey() && "L".equals(ke.getKey())) {
                    LoggingSettings.openLoggingSettings();
                }
            }));
        }
    }

    protected static class LoggerSettings {
        public H root = new H("div").attrs("style", "margin-bottom: 4px;text-align: right;border-bottom: 1px solid black;padding: 4px;");
        protected Logger logger;
        protected H level = LoggingSettings.createLogLevelChooser();
        protected H customLevel = new H("span");
        protected H priority = new H("span");

        protected void setLevel(LogLevel ll) {
            this.logger.setLogLevel((LoggingDetailLevel)ll);
            VanillaTools.setContent(this.level.getHtml(), ll.getLabel());
            this.priority.attrs("#text", String.valueOf(ll.getLevel()));
            HtmlTools.setVisible(this.customLevel.getHtml(), false);
            HtmlTools.setVisible(this.level.getHtml(), true);
        }

        public LoggerSettings(Logger log) {
            this.logger = log;
            this.root.addChilds(new H("span").attrs("#text", log.getFacilityName()).attrs("style", ""), this.level, this.customLevel, this.priority);
            LoggingDetailLevel l = log.getLogLevel();
            if (l instanceof LogLevel) {
                VanillaTools.setContent(this.level.getHtml(), ((LogLevel)l).name());
                HtmlTools.setVisible(this.customLevel.getHtml(), false);
            } else {
                this.customLevel.attrs("#text", l.getLabel());
                HtmlTools.setVisible(this.level.getHtml(), false);
            }
            this.priority.attrs("#text", String.valueOf(l.getLevel()));
            this.level.on("change", (EventListener<Event>)((EventListener)e -> {
                String lvl = VanillaTools.getContent(this.level.getHtml());
                LogLevel ll = (LogLevel)EnumTools.recogniseSymbol(LogLevel.class, (Object)lvl);
                if (null != ll) {
                    this.setLevel(ll);
                }
            }));
        }
    }
}

