/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.func;

import eu.javaexperience.text.Format;
import eu.jvx.js.generic.LiveTranslation;
import eu.jvx.js.lib.LabeledItem;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.input.SelectList;
import eu.jvx.js.lib.ui.component.input.SelectOption;
import java.util.Date;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;

public class HtmlDataContainerTools {
    public static HtmlDataContainer<String> tagInnerHtml(String tag, String ... attrs) {
        return HtmlDataContainerTools.innerHtml(VanillaTools.inlineCreateElement(tag, attrs));
    }

    public static HtmlDataContainer<String> innerHtml(final HTMLElement elem) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                this.root.setInnerHTML(data);
            }

            @Override
            public String getData() {
                return this.root.getInnerHTML();
            }

            @Override
            protected HTMLElement construct() {
                return elem;
            }
        };
    }

    public static HtmlDataContainer<String> tagInnerText(String tag, String ... attrs) {
        return HtmlDataContainerTools.innerText(VanillaTools.inlineCreateElement(tag, attrs));
    }

    public static HtmlDataContainer<String> innerText(final HTMLElement elem) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                VanillaTools.setInnerText(this.root, data);
            }

            @Override
            public String getData() {
                return VanillaTools.getInnerText(this.root);
            }

            @Override
            protected HTMLElement construct() {
                return elem;
            }
        };
    }

    public static HtmlDataContainer<String> input(final String type, final String ... attrs) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                ((HTMLInputElement)this.root).setValue(data);
            }

            @Override
            public String getData() {
                return ((HTMLInputElement)this.root).getValue();
            }

            @Override
            protected HTMLElement construct() {
                HTMLElement el = VanillaTools.inlineCreateElement("input", "type", type);
                VanillaTools.stringAttrs(el, attrs);
                return el;
            }
        };
    }

    public static HtmlDataContainer<String> select(final LabeledItem[] lis, final String ... attrs) {
        return new HtmlDataContainer<String>(){
            SelectList sl;

            @Override
            public void setData(String data) {
                this.sl.setSelectedValue(data);
            }

            @Override
            public String getData() {
                SelectOption it = this.sl.getSelectedItem();
                if (null == it) {
                    return null;
                }
                return it.getValue();
            }

            @Override
            protected HTMLElement construct() {
                this.sl = new SelectList();
                for (LabeledItem li : lis) {
                    this.sl.addOption(li.id, (HTMLElement)LiveTranslation.register(li.label, "span", new String[0]).getHtml());
                }
                VanillaTools.stringAttrs(this.sl.getHtml(), attrs);
                return this.sl.getHtml();
            }
        };
    }

    public static HtmlDataContainer<String> combined(final HtmlDataContainer<String> master, final HtmlDataContainer<String> slave, final String tag, final String ... attrs) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                master.setData(data);
                slave.setData(data);
            }

            @Override
            public String getData() {
                return (String)master.getData();
            }

            @Override
            public HTMLElement construct() {
                return new H(tag).attrs(attrs).addChilds(master, slave).getHtml();
            }
        };
    }

    public static HtmlDataContainer<String> wrapUnfunctional(final HTMLElement html) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
            }

            @Override
            public String getData() {
                return "";
            }

            @Override
            protected HTMLElement construct() {
                return html;
            }
        };
    }

    public static HtmlDataContainer<String> hiddenSpan() {
        final HTMLElement hidden = VanillaTools.inlineCreateElement("span", "style", "display:none");
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                VanillaTools.setInnerText(hidden, data);
            }

            @Override
            public String getData() {
                return VanillaTools.getInnerText(hidden);
            }

            @Override
            protected HTMLElement construct() {
                return new H("span").addChilds(hidden).getHtml();
            }
        };
    }

    public static HtmlDataContainer<String> browserDatetimeLocal(final HTMLInputElement e) {
        return new HtmlDataContainer<String>(){

            @Override
            protected HTMLElement construct() {
                return e;
            }

            @Override
            public String getData() {
                return e.getValue();
            }

            @Override
            public void setData(String data) {
                Date d = Format.strtotime.strtotime((String)data);
                if (null != d) {
                    e.setValue(Format.UTC_SQL_TIMESTAMP_MS.format(d));
                } else {
                    e.setValue("");
                }
            }
        };
    }

    public static HtmlDataContainer<String> wrapInput(final HTMLInputElement e) {
        return new HtmlDataContainer<String>(){

            @Override
            public void setData(String data) {
                ((HTMLInputElement)this.root).setValue(data);
            }

            @Override
            public String getData() {
                return ((HTMLInputElement)this.root).getValue();
            }

            @Override
            protected HTMLElement construct() {
                return e;
            }
        };
    }
}

