/*
 * Decompiled with CFR 0.152.
 */
package eu.teasite.frontend.api;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.semantic.references.MayNull;
import eu.teasite.frontend.api.ApiTransaction;
import eu.teasite.frontend.api.ApiTransactionCollector;
import eu.teasite.frontend.api.transfers.AjaxTransfer;
import eu.teasite.frontend.api.transfers.ApiPacketTransfer;
import eu.teasite.frontend.api.transfers.WebSocketTransfer;

public class ApiClient
extends ApiTransaction {
    protected EventMediator<DataObject> serverEvents = new EventMediator();

    public ApiClient(String startUrl, boolean websocket) {
        super(websocket ? WebSocketTransfer.connectPath(startUrl + "/websocket") : new AjaxTransfer(startUrl + "/ajax"));
        if (websocket) {
            WebSocketTransfer wst = (WebSocketTransfer)this.transfer;
            wst.setServerEventListener((SimplePublish1<DataObject>)((SimplePublish1)arg_0 -> this.serverEvents.dispatchEvent(arg_0)));
        }
    }

    public ApiClient(ApiPacketTransfer transfer) {
        super(transfer);
    }

    public EventMediator<DataObject> getServerEventManager() {
        return this.serverEvents;
    }

    public ApiTransaction startTransaction() {
        return new ApiTransactionCollector(this);
    }

    @Override
    protected ApiPacketTransfer wrapTransfer(Class cls, ApiPacketTransfer transfer) {
        return transfer;
    }

    @Override
    public void commit(@MayNull SimpleCall onDone) {
    }

    public static ApiClient connectTeasiteDefault(boolean websocket) {
        return new ApiClient("/site_api", websocket);
    }
}

