/*
 * Decompiled with CFR 0.152.
 */
package eu.teasite.frontend.api;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.rpc.client.JvxClientException;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.teasite.frontend.api.ApiClient;
import eu.teasite.frontend.api.ApiTransaction;
import eu.teasite.frontend.api.MultiplexedApiCall;
import eu.teasite.frontend.api.transfers.ApiPacketTransfer;
import java.util.ArrayList;

public class ApiTransactionCollector
extends ApiTransaction {
    protected ApiClient client;
    protected ArrayList<PendingRequest> pending = new ArrayList();
    protected long tid = 0L;

    public ApiTransactionCollector(ApiClient client) {
        super(client.transfer);
        this.client = client;
    }

    public ApiTransactionCollector(ApiPacketTransfer transfer) {
        super(transfer);
    }

    @Override
    protected ApiPacketTransfer wrapTransfer(final Class cls, ApiPacketTransfer transfer) {
        return new ApiPacketTransfer(){

            @Override
            public void transmitAsync(DataObject a, SimplePublish1<DataObject> b) {
                a.putString("N", cls.getSimpleName());
                long t = ApiTransactionCollector.this.pending.size();
                a.putLong("t", t);
                ApiTransactionCollector.this.pending.add(new PendingRequest(a, b));
            }
        };
    }

    @Override
    public void commit(final @MayNull SimpleCall onDone) {
        DataObjectTeaVMImpl o = new DataObjectTeaVMImpl();
        o.putLong("t", ++this.tid);
        final ArrayList packets = (ArrayList)this.pending.clone();
        this.pending.clear();
        DataArray ps = o.newArrayInstance();
        for (int i = 0; i < packets.size(); ++i) {
            ps.putObject(((PendingRequest)packets.get((int)i)).req);
        }
        o.putArray("p", ps);
        MultiplexedApiCall multi = this.client.getApiClass(MultiplexedApiCall.class);
        multi.doMulticall(new SimplePublish2<DataObject, JvxClientException>(){

            public void publish(DataObject ret, JvxClientException b) {
                DataArray arr = ret.getArray("r");
                for (int i = 0; i < arr.size(); ++i) {
                    DataObject resp = arr.getObject(i);
                    try {
                        Object o = resp.get("t");
                        int id = (Integer)CastTo.Int.cast(o);
                        SimplePublish1<DataObject> cb = ((PendingRequest)packets.get((int)id)).callback;
                        if (null == cb) continue;
                        cb.publish((Object)resp);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (null != onDone) {
                    onDone.call();
                }
            }
        }, (Object)o);
    }

    protected static class PendingRequest {
        DataObject req;
        SimplePublish1<DataObject> callback;

        public PendingRequest(DataObject req, SimplePublish1<DataObject> callback) {
            this.req = req;
            this.callback = callback;
        }
    }
}

