/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teavm;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.dispatch.url.spec.compile.WebCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.SourceFileInfo;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMOptimizationLevel;

public class TeaVmWebCompiler
implements WebCompiler {
    protected Class<?> mainClass;
    protected File tmpDir;
    protected boolean compactize = false;
    protected TeaVMTool compiler;
    protected static final TeaVMToolLog TEAVM_LOG = new TeaVMToolLog(){

        public void warning(String arg0, Throwable arg1) {
            System.out.println(arg0);
            arg1.printStackTrace();
        }

        public void warning(String arg0) {
            System.out.println(arg0);
        }

        public void info(String arg0, Throwable arg1) {
            System.out.println(arg0);
            arg1.printStackTrace();
        }

        public void info(String arg0) {
            System.out.println(arg0);
        }

        public void error(String arg0, Throwable arg1) {
            System.out.println(arg0);
            arg1.printStackTrace();
        }

        public void error(String arg0) {
            System.out.println(arg0);
        }

        public void debug(String arg0, Throwable arg1) {
            System.out.println(arg0);
            arg1.printStackTrace();
        }

        public void debug(String arg0) {
            System.out.println(arg0);
        }
    };
    protected HashSet<String> sourceDirs = new HashSet();

    public TeaVmWebCompiler(Class<?> mainClass, File tmpDir) {
        this.mainClass = mainClass;
        this.tmpDir = tmpDir;
    }

    protected TeaVMTool getConfiguredCompiler() {
        if (null == this.compiler) {
            TeaVMTool t = new TeaVMTool();
            this.tmpDir.mkdirs();
            t.setLog(TEAVM_LOG);
            t.addSourceFileProvider(new SourceFileProvider(){

                public void open() throws IOException {
                }

                public SourceFileInfo getSourceFile(String arg0) throws IOException {
                    if (null == arg0) {
                        return null;
                    }
                    File _src = null;
                    for (String s : TeaVmWebCompiler.this.sourceDirs) {
                        File f = new File(s + "/" + arg0);
                        if (!f.exists()) continue;
                        _src = f;
                        break;
                    }
                    if (null == _src) {
                        return null;
                    }
                    final File src = _src;
                    return new SourceFileInfo(){

                        public InputStream open() throws IOException {
                            return new FileInputStream(src);
                        }

                        public long lastModified() {
                            return src.lastModified();
                        }
                    };
                }

                public void close() throws IOException {
                }
            });
            if (this.compactize) {
                t.setDebugInformationGenerated(false);
                t.setOptimizationLevel(TeaVMOptimizationLevel.FULL);
                t.setMinifying(true);
            } else {
                t.setDebugInformationGenerated(true);
                t.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
                t.setMinifying(false);
            }
            t.setClassLoader(Thread.currentThread().getContextClassLoader());
            t.setCacheDirectory(this.tmpDir);
            t.setMainClass(this.mainClass.getName());
            t.setTargetType(TeaVMTargetType.JAVASCRIPT);
            t.setTargetDirectory(this.tmpDir);
            t.setTargetFileName("out.js");
            this.compiler = t;
        }
        return this.compiler;
    }

    public void addSourceSearchDir(String dir) {
        if (null != dir) {
            this.sourceDirs.add(dir);
        }
    }

    public void compile(boolean incremental) {
        try {
            TeaVMTool c = this.getConfiguredCompiler();
            c.generate();
            ProblemProvider problems = c.getProblemProvider();
            if (!problems.getProblems().isEmpty()) {
                TeaVMProblemRenderer.describeProblems((TeaVM)((TeaVM)Mirror.tryGetFieldValue((Object)c, (String)"vm")), (TeaVMToolLog)TEAVM_LOG);
            } else {
                this.accumulateUsedSourceFilesList(c.getUsedResources().toArray(Mirror.emptyStringArray));
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
    }

    public void emitMergedOutput(String destinationFile) {
        try {
            IOTools.putFileContent((String)destinationFile, (byte[])Mirror.emptyByteArray);
            if (new File(this.tmpDir + "/runtime.js").exists()) {
                IOTools.appendData((String)destinationFile, (byte[])IOTools.loadFileContent((String)(this.tmpDir + "/runtime.js")));
            }
            if (new File(this.tmpDir + "/additional.js").exists()) {
                IOTools.appendData((String)destinationFile, (byte[])IOTools.loadFileContent((String)(this.tmpDir + "/additional.js")));
            }
            IOTools.appendData((String)destinationFile, (byte[])IOTools.loadFileContent((String)(this.tmpDir + "/out.js")));
            new File(destinationFile).setLastModified(this.getSourcesLastModification());
        }
        catch (Exception e) {
            e.printStackTrace();
            new File(destinationFile).delete();
        }
    }

    protected File getSourceListFile() {
        return new File(this.tmpDir + "/sources.list");
    }

    protected void accumulateUsedSourceFilesList(String[] list) throws IOException {
        IOTools.putFileContent((String)this.getSourceListFile().toString(), (byte[])StringTools.join((String)"\n", (String[])list).getBytes());
    }

    protected Collection<String> getUsedFiles() {
        File lst = this.getSourceListFile();
        ArrayList<String> ret = null;
        if (lst.exists()) {
            ret = new ArrayList<String>();
            try {
                IOTools.loadFillAllLine((String)lst.toString(), ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != ret && !ret.isEmpty()) {
            return ret;
        }
        TeaVMTool compiler = this.getConfiguredCompiler();
        Collection di = compiler.getUsedResources();
        if (di.isEmpty()) {
            try {
                compiler.generate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            di = compiler.getUsedResources();
        }
        try {
            this.accumulateUsedSourceFilesList(di.toArray(Mirror.emptyStringArray));
        }
        catch (IOException e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return di;
    }

    public long getSourcesLastModification() {
        long ret = 0L;
        for (String cls : this.getUsedFiles()) {
            try {
                String c = StringTools.replaceAllStrings((String)StringTools.getSubstringBeforeLastString((String)cls, (String)".java"), (String)"/", (String)".");
                URL url = Mirror.getClassUrl(Class.forName(c));
                long t = new File(URLDecoder.decode(url.getFile())).lastModified();
                if (ret >= t) continue;
                ret = t;
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }

    public void setCompactize(boolean b) {
        this.compactize = b;
    }

    public boolean isProduction() {
        return this.compactize;
    }

    public void setProduction(boolean val) {
        this.compactize = val;
    }
}

