/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.input;

import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.input.SelectList;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLOptionElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;

public class SelectOption
implements ImpersonalisedHtml {
    protected SelectList owner;
    protected HTMLOptionElement option;

    protected SelectOption(SelectList selectList, String value, String label) {
        this.owner = selectList;
        this.option = (HTMLOptionElement)VanillaTools.inlineCreateElement("option", "value", value, "#text", label);
    }

    protected SelectOption(SelectList selectList, String value, HTMLElement label) {
        this.owner = selectList;
        this.option = (HTMLOptionElement)VanillaTools.inlineCreateElement("option", "value", value);
        this.option.appendChild((Node)label);
    }

    public boolean isSelected() {
        return true == this.option.isSelected();
    }

    public void setEnabled(boolean enabled) {
        if (this.isSelected()) {
            this.owner.resetSelection();
        }
        this.option.setDisabled(!enabled);
    }

    public void setHidden(boolean hidden) {
        this.setEnabled(!hidden);
        if (hidden) {
            this.option.getStyle().setProperty("display", "hidden");
        } else {
            this.option.getStyle().setProperty("display", "");
        }
    }

    public void remove() {
        this.owner.remove(this);
        VanillaTools.remove((Element)this.option);
    }

    public void deselect() {
        this.option.setSelected(false);
    }

    public void selectThis() {
        this.owner.resetSelection();
        this.option.setSelected(true);
    }

    public String getValue() {
        return this.option.getValue();
    }

    public String getLabel() {
        return this.option.getInnerHTML();
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    @Override
    public Element getHtml() {
        return this.option;
    }
}

