/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.input;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.input.SelectOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class SelectList
extends HtmlDataContainer<String>
implements ImpersonalisedHtml {
    protected List<SelectOption> opts = new ArrayList<SelectOption>();

    public static SelectList createFrom(List<Map<String, Object>> data, GetBy1<String, Map<String, Object>> getValue, GetBy1<String, Map<String, Object>> getLabel) {
        SelectList ret = new SelectList();
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> d = data.get(i);
            String value = (String)getValue.getBy(d);
            String label = (String)getLabel.getBy(d);
            if (null == value || null == label) continue;
            ret.addOption(value, label);
        }
        return ret;
    }

    public SelectOption getOptionByValue(String name) {
        for (int i = 0; i < this.opts.size(); ++i) {
            SelectOption so = this.opts.get(i);
            if (!name.equals(so.getValue())) continue;
            return so;
        }
        return null;
    }

    public SelectOption setSelectedValue(String value) {
        SelectOption opt = this.getOptionByValue(value);
        if (null != opt) {
            opt.selectThis();
        }
        return opt;
    }

    public SelectOption addOption(String value, String label) {
        if (null != this.getOptionByValue(value)) {
            return null;
        }
        SelectOption opt = new SelectOption(this, value, label);
        this.opts.add(opt);
        this.root.appendChild((Node)opt.option);
        return opt;
    }

    public SelectOption addOption(String value, HTMLElement label) {
        if (null != this.getOptionByValue(value)) {
            return null;
        }
        SelectOption opt = new SelectOption(this, value, label);
        this.opts.add(opt);
        this.root.appendChild((Node)opt.option);
        return opt;
    }

    public void resetSelection() {
        for (int i = 0; i < this.opts.size(); ++i) {
            this.opts.get(i).deselect();
        }
    }

    public SelectOption getSelectedItem() {
        for (int i = 0; i < this.opts.size(); ++i) {
            SelectOption so = this.opts.get(i);
            if (!so.isSelected()) continue;
            return so;
        }
        return null;
    }

    public List<SelectOption> getOptions() {
        return this.opts;
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    @Override
    public HTMLElement getHtml() {
        return this.root;
    }

    protected void remove(SelectOption selectOption) {
        for (int i = 0; i < this.opts.size(); ++i) {
            if (this.opts.get(i) != selectOption) continue;
            this.opts.remove(i);
            this.root.removeChild((Node)selectOption.option);
        }
    }

    public void clear() {
        this.opts.clear();
        VanillaTools.removeAllChild(this.root);
    }

    @Override
    protected HTMLElement construct() {
        return ImpTools.appendImp(VanillaTools.inlineCreateElement("select", new String[0]), this);
    }

    @Override
    public String getData() {
        SelectOption si = this.getSelectedItem();
        if (null != si) {
            return si.getValue();
        }
        return null;
    }

    @Override
    public void setData(String data) {
        SelectOption opt = this.getOptionByValue(data);
        if (null != opt) {
            opt.selectThis();
        }
    }

    static {
        if (TeaVmTools.isUrchin()) {
            SelectList sl = new SelectList();
            sl.addOption("something", "something");
            sl.setData("something");
            System.out.println(sl.getData());
        }
    }
}

