/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.CustomEvent;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.VanillaTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public class HtmlTools {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("HtmlTools"));

    public static void setTextContentShowHide(HTMLElement node, boolean changeVisibility, String content) {
        HtmlTools.setContentReal(node, changeVisibility, 0, content);
    }

    public static void setHtmlContentShowHide(HTMLElement node, boolean changeVisibility, Node content) {
        HtmlTools.setContentReal(node, changeVisibility, 1, content);
    }

    public static void setImpersinalisedHtmlContentShowHide(HTMLElement node, boolean changeVisibility, ImpersonalisedHtml content) {
        HtmlTools.setContentReal(node, changeVisibility, 1, content);
    }

    protected static void setContentReal(HTMLElement node, boolean changeVisibility, int mode, Object content) {
        node.setInnerHTML("");
        if (null != content) {
            switch (mode) {
                case 0: {
                    node.setInnerHTML(content.toString());
                    break;
                }
                case 1: {
                    node.appendChild((Node)content);
                    break;
                }
                case 2: {
                    node.appendChild((Node)((ImpersonalisedHtml)content).getHtml());
                }
            }
        }
        if (changeVisibility) {
            if (null == content) {
                node.getStyle().setProperty("display", "none");
            } else {
                node.getStyle().setProperty("display", "");
            }
        }
    }

    public static int childIndex(Element e) {
        if (null != e.getParentNode()) {
            JSArray<HTMLElement> cn = VanillaTools.getChildren((HTMLElement)e.getParentNode());
            for (int i = 0; i < cn.getLength(); ++i) {
                if (e != cn.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<Node> removeChilds(HTMLElement target) {
        ArrayList<Node> ret = new ArrayList<Node>();
        JSArray<HTMLElement> cn = VanillaTools.getChildren(target);
        for (int i = 0; i < cn.getLength(); ++i) {
            Node e = (Node)cn.get(i);
            target.removeChild(e);
            ret.add(e);
        }
        return ret;
    }

    public static void addChilds(Element target, List<? extends Element> childs) {
        for (int i = 0; i < childs.size(); ++i) {
            target.appendChild((Node)childs.get(i));
        }
    }

    public static void replaceTo(HTMLElement from, HTMLElement to) {
        from.getParentNode().insertBefore((Node)to, (Node)from);
        VanillaTools.remove((Element)from);
    }

    public static void setChild(HTMLElement owner, HTMLElement onlyChild) {
        owner.setInnerHTML("");
        owner.appendChild((Node)onlyChild);
    }

    public static boolean toggleVisiblity(HTMLElement el) {
        return HtmlTools.setVisible(el, !HtmlTools.isVisible(el));
    }

    public static boolean isVisible(HTMLElement el) {
        String d = el.getStyle().getPropertyValue("display");
        return !d.equals("none") && !d.equals("hidden");
    }

    public static boolean setVisible(HTMLElement el, boolean show) {
        if (show) {
            el.getStyle().setProperty("display", "");
        } else {
            el.getStyle().setProperty("display", "none");
        }
        return show;
    }

    public static void serializeInputs(Map<String, String> dst, HTMLElement in) {
        NodeList els = in.querySelectorAll("input, textarea, select, output");
        for (int i = 0; i < els.getLength(); ++i) {
            HTMLElement el = (HTMLElement)els.get(i);
            String name = el.getAttribute("name");
            if (StringTools.isNullOrTrimEmpty((String)name)) continue;
            boolean executed = el.dispatchEvent((Event)CustomEvent.create("serialize"));
            String cont = VanillaTools.getContent(el);
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"dispatch serailize event, executed: %s, element: %s, name: %s, val: %s", (Object[])new Object[]{executed, VanillaTools.getDomPath(el), name, cont});
            }
            dst.put(name, cont);
        }
    }
}

