/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.table;

import eu.javaexperience.collection.map.KeyVal;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.ui.component.table.Tabifier;
import eu.jvx.js.lib.ui.component.table.TableCell;
import eu.jvx.js.lib.ui.component.table.TableCellConfig;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.lib.ui.component.table.TableStructureManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.jso.dom.html.HTMLElement;

public class Table
implements ImpersonalisedHtml {
    public TableStructureManager tm;
    public HTMLElement table;
    public Map<String, Map.Entry<String, TableCellConfig>[]> rowTypes;

    public Table(TableStructureManager tm) {
        this.tm = tm;
        this.table = ImpTools.appendImp(tm.createEmptyTable(), this);
        this.rowTypes = new HashMap<String, Map.Entry<String, TableCellConfig>[]>();
    }

    public boolean isRowTypeRegistered(String name) {
        return null != this.rowTypes.get(name);
    }

    public void assertRowTypeRegistered(String name) {
        if (!this.isRowTypeRegistered(name)) {
            System.out.println(name + " row type not registered.");
            throw new RuntimeException(name + " row type not registered.");
        }
    }

    public void assertRowTypeNotRegistered(String name) {
        if (this.isRowTypeRegistered(name)) {
            System.out.println(name + " row type already registered.");
            throw new RuntimeException(name + " row type already registered.");
        }
    }

    public static Map.Entry<String, TableCellConfig>[] createSimpleConfig(List<String> colNames) {
        Map.Entry[] cre = new Map.Entry[colNames.size()];
        for (int i = 0; i < colNames.size(); ++i) {
            cre[i] = new KeyVal((Object)colNames.get(i), (Object)TableCellConfig.DEFAULT_1x1_String_set_get);
        }
        return cre;
    }

    public static Map.Entry<String, TableCellConfig>[] createSimpleConfig(String ... colNames) {
        Map.Entry[] cre = new Map.Entry[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            cre[i] = new KeyVal((Object)colNames[i], (Object)TableCellConfig.DEFAULT_1x1_String_set_get);
        }
        return cre;
    }

    public void registerSimpleRowConfig(String name, String ... colNames) {
        this.assertRowTypeNotRegistered(name);
        this.registerRowType(name, Table.createSimpleConfig(colNames));
    }

    public void registerSimpleRowConfig(String name, List<String> colNames) {
        this.assertRowTypeNotRegistered(name);
        this.registerRowType(name, Table.createSimpleConfig(colNames));
    }

    public void registerRowType(String name, Map.Entry<String, TableCellConfig> ... cfg) {
        this.assertRowTypeNotRegistered(name);
        this.rowTypes.put(name, cfg);
    }

    public int getColIndexByName(String rowType, String fieldName) {
        this.assertRowTypeRegistered(rowType);
        Map.Entry<String, TableCellConfig>[] cfg = this.rowTypes.get(rowType);
        for (int i = 0; i < cfg.length; ++i) {
            if (!fieldName.equals(cfg[i].getKey())) continue;
            return i;
        }
        return -1;
    }

    public static <T> Table createTableFrom(TableStructureManager mngr, Tabifier<T> processor, List<T> data) {
        Table ret = new Table(mngr);
        for (int i = 0; i < data.size(); ++i) {
            T d = data.get(i);
            String type = (String)processor.getRecordType.getBy(d);
            if (null == type) {
                throw new RuntimeException("Can't fetch table row type of data: " + d);
            }
            Map.Entry[] cfg = (Map.Entry[])processor.getRecordTypeConfig.getBy((Object)type);
            if (null == cfg) {
                throw new RuntimeException("Not table row type configuration specified for: " + type);
            }
            if (!ret.isRowTypeRegistered(type)) {
                ret.registerRowType(type, cfg);
            }
            TableRow tr = ret.createRow(type);
            for (int c = 0; c < cfg.length; ++c) {
                Map.Entry tcc = cfg[i];
                String name = (String)tcc.getKey();
                TableCell tc = tr.getCellByName(name);
                Object value = processor.getRecordCellValue.getBy(d, (Object)name);
                ((TableCellConfig)tcc.getValue()).setter.publish((Object)tc, value);
            }
        }
        return ret;
    }

    public TableRow createRow(String name) {
        this.assertRowTypeRegistered(name);
        int next = this.tm.getNumberOfRows(this);
        return this.tm.createRowAtIndex(this, name, next);
    }

    public TableRow getRowAt(int index) {
        return this.tm.getRowAtIndex(this, index);
    }

    public Map.Entry<String, TableCellConfig>[] getRowType(String name) {
        return this.rowTypes.get(name);
    }

    public int getNumberOfRows() {
        return this.tm.getNumberOfRows(this);
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    public HTMLElement getHtml() {
        return this.table;
    }
}

