/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui;

import eu.javaexperience.collection.map.PublisherMap;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.NativeJsSupport;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import java.util.Collection;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Node;

public class FrontendTools {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("FrontendTools"));
    protected static final String CHECK_THREAD = "window.$rt_currentNativeThread";

    public static void bindFormClickTrigger(HTMLElement area, String triggerSelector, SimplePublish1<DataObject> areaData) {
        FrontendTools.bindFormTrigger(area, triggerSelector, "click", areaData);
    }

    public static DataObject serializeInputsInArea(HTMLElement area) {
        return FrontendTools.serializeInputsInArea(area, (DataCommon)DataObjectTeaVMImpl.INSTANCE);
    }

    public static DataObject serializeInputsInArea(HTMLElement area, DataCommon proto) {
        final DataObject obj = proto.newObjectInstance();
        HtmlTools.serializeInputs((Map<String, String>)new PublisherMap<String, String>(){

            public String put(String key, String value) {
                if (!obj.has(key)) {
                    obj.putString(key, value);
                }
                return null;
            }
        }, area);
        return obj;
    }

    public static void bindFormTrigger(final HTMLElement area, String triggerSelector, String action, final SimplePublish1<DataObject> areaData) {
        VanillaTools.bindListenerToArea(area, action, triggerSelector, new EventListener<Event>(){

            public void handleEvent(Event arg0) {
                DataObject obj = FrontendTools.serializeInputsInArea(area, (DataCommon)DataObjectTeaVMImpl.INSTANCE);
                areaData.publish((Object)obj);
            }
        });
    }

    public static <T extends Event> void processEventWithThread(final EventListener<T> listener, final T event) {
        if (TeaVmTools.isValuable((JSObject)NativeJsSupport.getSupport().eval(CHECK_THREAD))) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"processEventWithThread: dispatch on this thread", (Object[])new Object[0]);
            listener.handleEvent(event);
        } else {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"processEventWithThread: dispatch on NEW thread", (Object[])new Object[0]);
            new Thread(){

                @Override
                public void run() {
                    listener.handleEvent(event);
                }
            }.start();
        }
    }

    public static <T extends Event> EventListener<T> wrapProcessEventWithThread(final EventListener<T> listener) {
        return new EventListener<T>(){

            public void handleEvent(T arg0) {
                if (TeaVmTools.isValuable((JSObject)NativeJsSupport.getSupport().eval(FrontendTools.CHECK_THREAD))) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"processEventWithThread: dispatch on this thread", (Object[])new Object[0]);
                    listener.handleEvent(arg0);
                } else {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"wrapProcessEventWithThread: dispatch on NEW thread", (Object[])new Object[0]);
                    new Thread((Event)arg0){
                        final /* synthetic */ Event val$arg0;
                        {
                            this.val$arg0 = event;
                        }

                        @Override
                        public void run() {
                            listener.handleEvent(this.val$arg0);
                        }
                    }.start();
                }
            }
        };
    }

    public static void runOnThread(final SimpleCall simpleCall) {
        if (TeaVmTools.isValuable((JSObject)NativeJsSupport.getSupport().eval(CHECK_THREAD))) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"runOnThread: dispatch on this thread", (Object[])new Object[0]);
            simpleCall.call();
        } else {
            new Thread(){

                @Override
                public void run() {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"runOnThread: dispatch on NEW thread", (Object[])new Object[0]);
                    simpleCall.call();
                }
            }.start();
        }
    }

    public static <A, B> SimplePublish2<A, B> wrapDispatchWithThread(final SimplePublish2<A, B> param) {
        return new SimplePublish2<A, B>(){

            public void publish(final A a, final B b) {
                if (TeaVmTools.isValuable((JSObject)NativeJsSupport.getSupport().eval(FrontendTools.CHECK_THREAD))) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"wrapDispatchWithThread: dispatch on this thread", (Object[])new Object[0]);
                    param.publish(a, b);
                } else {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"wrapDispatchWithThread: dispatch on NEW thread", (Object[])new Object[0]);
                    new Thread(){

                        @Override
                        public void run() {
                            param.publish(a, b);
                        }
                    }.start();
                }
            }
        };
    }

    public static String renderEntry(LanguageTranslatableValidationEntry ent) {
        return ((TranslationFriendlyValidationEntry)ent.getDescription()).propertyName + " " + ((TranslationFriendlyValidationEntry)ent.getDescription()).translationSymbol;
    }

    public static String renderMessages(Collection<LanguageTranslatableValidationEntry> reportEntries) {
        StringBuilder sb = new StringBuilder();
        for (LanguageTranslatableValidationEntry e : reportEntries) {
            sb.append(FrontendTools.renderEntry(e));
        }
        return sb.toString();
    }

    public static void log(LoggingDetailLevel level, String format, Object ... vars) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)level, (String)format, (Object[])vars);
    }

    public static void log(LoggingDetailLevel level, Throwable t, String format, Object ... vars) {
        LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)level, (Throwable)t, (String)format, (Object[])vars);
    }

    public static HTMLInputElement addHiddenSerializer(String fieldName, HTMLElement container, final HtmlDataContainer<String> ret) {
        final H in = new H("input").attrs("name", fieldName, "type", "hidden");
        in.on("serialize", new EventListener<Event>(){

            public void handleEvent(Event arg0) {
                String ser = (String)ret.getData();
                ((HTMLInputElement)in.getHtml()).setValue(ser);
            }
        });
        container.appendChild((Node)in.getHtml());
        return (HTMLInputElement)in.getHtml();
    }
}

