/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.table;

import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.NativeJsSupport;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.table.Table;
import eu.jvx.js.lib.ui.component.table.TableCell;
import eu.jvx.js.lib.ui.component.table.TableCellConfig;
import eu.jvx.js.lib.ui.component.table.TableCellVisualSettings;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.lib.ui.component.table.TableStructureManager;
import java.util.Map;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;

public class SimpleTableStructureManager
implements TableStructureManager {
    public static final SimpleTableStructureManager INSTANCE = new SimpleTableStructureManager();

    @Override
    public HTMLElement createEmptyTable() {
        return VanillaTools.appendChilds(VanillaTools.inlineCreateElement("table", new String[0]), VanillaTools.inlineCreateElement("tbody", new String[0]));
    }

    protected HTMLElement locateRoot(HTMLElement e) {
        return e.querySelector("tbody");
    }

    @Override
    public TableCell accessRowCell(TableRow row, int col) {
        HTMLElement vn = (HTMLElement)VanillaTools.getChildren((HTMLElement)row.cfg).get(col);
        if (null == vn) {
            return null;
        }
        return new TableCell(row, vn);
    }

    @Override
    public int getNumberOfRows(Table table) {
        return VanillaTools.getChildren(this.locateRoot(table.getHtml())).getLength();
    }

    @Override
    public TableRow createRowAtIndex(Table owner, String name, int index) {
        Map.Entry<String, TableCellConfig>[] type = owner.getRowType(name);
        HTMLElement root = this.locateRoot(owner.getHtml());
        JSArray<HTMLElement> ch = VanillaTools.getChildren(root);
        if (index > ch.getLength()) {
            throw new RuntimeException("Can't create new table row to position: " + index + ", when have only " + ch.getLength() + " rows");
        }
        HTMLElement add = VanillaTools.inlineCreateElement("tr", new String[0]);
        for (int i = 0; i < type.length; ++i) {
            HTMLElement td = VanillaTools.inlineCreateElement("td", new String[0]);
            TableCellVisualSettings cfg = type[i].getValue().config;
            NativeJsSupport.getSupport().setProp(td, "colSpan", "" + cfg.colspan);
            NativeJsSupport.getSupport().setProp(td, "rowSpan", "" + cfg.rowspan);
            add.appendChild((Node)td);
        }
        VanillaTools.getDataSet(add).put("rowtype", name);
        TableRow tr = new TableRow(owner);
        tr.cfg = add;
        ImpTools.appendImp(add, tr);
        if (index == ch.getLength()) {
            root.appendChild((Node)add);
        } else {
            root.insertBefore((Node)add, (Node)ch.get(index));
        }
        return tr;
    }

    @Override
    public TableRow getRowAtIndex(Table table, int index) {
        Element elem = (Element)VanillaTools.getChildren(this.locateRoot(table.getHtml())).get(index);
        if (null == elem) {
            return null;
        }
        TableRow tr = new TableRow(table);
        tr.cfg = elem;
        return tr;
    }

    @Override
    public int getRowIndex(TableRow tableRow) {
        return HtmlTools.childIndex((Element)tableRow.cfg);
    }

    @Override
    public String getRowType(TableRow tableRow) {
        return VanillaTools.getDataSet((HTMLElement)tableRow.cfg).get("rowtype");
    }
}

