/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.saac;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.rpc.client.JvxClientException;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.NativeJsSupport;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.ui.Autocomplete;
import eu.jvx.saac.SaacApi;
import java.util.ArrayList;
import java.util.List;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.browser.Window;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;
import org.teavm.jso.json.JSON;

public class SaacEditor {
    protected String name = String.valueOf(Integer.toHexString(System.identityHashCode(this)));
    protected final HTMLElement target;
    protected final SaacConfig config;
    protected final SaacApi rpc;
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SaacEditor"));
    public static final String ROOT_NAMESPACE = "fixture_namespace";
    public static final String ROOT_FIXTURE_FUNCTION_NAME = "fixture_function";
    public static final String ROOT_FIXTURE_FUNCTION_INDEX = "fixture_argument_index";
    protected List<DataObject> saacFunctions;
    protected HTMLElement consoleDom;

    public SaacEditor(HTMLElement target, SaacConfig config) {
        this.target = target;
        this.config = config;
        this.rpc = config.api;
    }

    protected static String renderTemplate(String name) {
        if ("saac/argument".equals(name)) {
            return "\t\t<div class=\"saac saac_argument\">\n\t\t\t<!-- TODO Toolbar -->\n\t\t\t<div class=\"saac saac_arg_type\"></div> <div class=\"saac saac_arg_name\"></div>:<div class=\"saac saac_arg_descr\"></div>\n\t\t\t\n\t\t\t\n\t\t\t<div class=\"saac saac_argument_menu\">\n\t\t\t\t<div class=\"saac saac_show_menu glyphicon glyphicon-eye-open\"></div>\n\t\t\t\t<div class=\"saac saac_operation_remove glyphicon glyphicon-remove-circle\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s t\u00f6rl\u00e9se\">\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_clipboard_cut glyphicon glyphicon-scissors\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s kiv\u00e1g\u00e1sa\">\n\t\t\t\t</div>\n\t\t\n\t\t\t\t<div class=\"saac saac_operation_insert_from_clipboard glyphicon glyphicon-paste\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s beilleszt\u00e9se\">\n\t\t\t\t\t<textarea class=\"saac saac_clipboard_insert_area\"></textarea>\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_all_clipboard glyphicon glyphicon-copy\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s m\u00e1sol\u00e1sa\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\n\t\t\t<div class=\"saac saac_arg_container\">\n\t\t\t\t\n\t\t\t</div>\n\t\t\n\t\t\t<div class=\"saac saac_argument_variadic_menu\">\n\t\t\t\t<button class=\"saac saac_varadic_add glyphicon glyphicon-plus-sign\" data-toggle=\"tooltip\" title=\"Param\u00e9ter hozz\u00e1ad\u00e1sa\"></button>\n\t\t\t\n\t\t\t</div>\n\t\t</div>";
        }
        if ("saac/function_container".equals(name)) {
            return "<div class=\"saac saac_function_container\">\n\t\t\t<div class=\"saac saac_function_description\"></div>\n\t\t\t<button class=\"saac saac_varadic_remove glyphicon glyphicon-minus-sign\"></button>\n\t\t\t<!-- \n\t\t\t\tAutocomplete-n\u00e9l:\n\t\t\t\t\tkell a container sz\u00fcl\u0151j\u00e9nek a tipusa\n\t\t\t\n\t\t\tA funkci\u00f3k 3 szintje:\n\t\t\t\t- \"gener\u00e1l\u00e1s fut\u00e1s id\u0151ben\": SimpleGet<GetBy1<?, ?>> \n\t\t\t\t- Els\u0151rend\u0171 f\u00fcggv\u00e9nyek: GetBy<Return, Input>\n\t\t\t\t- util f\u00fcggv\u00e9nyek: concat(\"valami: \", 12)\n\t\t\t -->\n\t\t\t\n\t\t\t<input type=\"hidden\" name=\"w\" class=\"saac f_wrapper\"/>\n\t\t\t\n\t\t\t\n\t\t\t<input type=\"hidden\" name=\"f\" class=\"saac saac_f_function_id\"/>\n\t\t\t\n\t\t\t<div class=\"saac saac_f_ret_type\"></div><br/>\n\t\t\t\n\t\t\t<input type=\"text\" class=\"saac saac_function_autocomplete autocomplete\" data-originsize=\"5\" size=\"5\" placeholder=\"\"/>\n\t\t\t<button class=\"saac saac_view_arguments_mode glyphicon glyphicon-resize-vertical\"></button>\n\t\t\t\n\t\t\t<div class=\"saac saac_f_arguments\">\n\t\t\t\t<!-- entries -->\n\t\t\t</div>\n\t\t</div>";
        }
        if ("saac/main".equals(name)) {
            return "<div class=\"saac saac-minimal saac_entry_point\">\n\t\t\t<div class=\"saac saac_menubar\">\n\t\t\t\t<div class=\"saac saac_operation_remove saac_top_level_opearation glyphicon glyphicon-remove-circle\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s t\u00f6rl\u00e9se\">\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_clipboard_cut saac_top_level_opearation glyphicon glyphicon-scissors\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s kiv\u00e1g\u00e1sa\">\n\t\t\t\t</div>\n\t\t\n\t\t\t\t<div class=\"saac saac_operation_insert_from_clipboard saac_top_level_opearation glyphicon glyphicon-paste\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s beilleszt\u00e9se\">\n\t\t\t\t\t<textarea class=\"saac saac_clipboard_insert_area\"></textarea>\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_all_clipboard saac_top_level_opearation glyphicon glyphicon-copy\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s m\u00e1sol\u00e1sa\">\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_save saac_top_level_opearation glyphicon glyphicon-floppy-disk\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s ment\u00e9se lemezre\">\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_execute saac_top_level_opearation glyphicon glyphicon-triangle-right\" data-toggle=\"tooltip\" title=\"Elj\u00e1r\u00e1s futtat\u00e1sa\">\n\t\t\t\t</div>\n\t\t\t\t\n\t\t\t\t<div class=\"saac saac_operation_show_console saac_top_level_opearation glyphicon glyphicon-console\" data-toggle=\"tooltip\" title=\"Konzol megnyit\u00e1sa\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t\n\t\t\t<div class=\"saac saac_project_file_container\">\n\t\t\t\t\n\t\t\t</div>\n\t\t\t\n\t\t\t<div class=\"saac saac_primary_container\">\n\t\t\t\t<div class=\"saac saac_no_show saac_root_accept_type\"></div>\n\t\t\t\t<div class=\"saac saac_arg_type saac_root_type_name\"></div>\n\t\t\t</div>\n\t\t\t\n\t\t\t\n\t\t\t<div class=\"saac saac_no_show saac_hidden_console_content\">\n\t\t\t\t<div class=\"saac saac_console_root\">\n\t\t\t\t\t<pre class=\"saac saac_log_container\">\n\t\t\t\t\t\n\t\t\t\t\t</pre>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t\n\t\t</div>";
        }
        if ("saac/type".equals(name)) {
            return "<div class=\"saac_template_type\"></div>";
        }
        return "template doesn't exists: " + name;
    }

    protected void notify_user(String type, String text) {
        if (null != this.config.customNotify) {
            this.config.customNotify.publish((Object)type, (Object)text);
        } else {
            Window.alert((String)text);
        }
    }

    public static String shorten_type(String str) {
        str = StringTools.getSubstringAfterLastString((String)str, (String)".");
        str = str.replaceAll(";", "[]");
        return str;
    }

    public static String saac_type_get_typeclass(DataObject t) {
        if (t.has("genericComponentType")) {
            return SaacEditor.saac_type_get_typeclass(t.getObject("genericComponentType"));
        }
        if (t.has("class")) {
            return "primitive";
        }
        if (t.has("rawType")) {
            boolean func_no_ret;
            String cls = SaacEditor.shorten_type(t.getObject("rawType").getString("class"));
            boolean subj_func = cls.startsWith("GetBy") || "SimpleGet".equals(cls);
            boolean bl = func_no_ret = cls.startsWith("SimplePublish") || "SimpleCall".equals(cls);
            if (subj_func || func_no_ret) {
                return "function";
            }
        } else {
            return "compaund";
        }
        return "unknown";
    }

    public static String saac_type_render(DataObject t) {
        if (t.has("rawType")) {
            String ret = "";
            String cls = SaacEditor.shorten_type(t.getObject("rawType").getString("class"));
            boolean subj_func = cls.startsWith("GetBy") || "SimpleGet".equals(cls);
            boolean func_no_ret = cls.startsWith("SimplePublish") || "SimpleCall".equals(cls);
            int off = 0;
            if (subj_func |= func_no_ret) {
                if (func_no_ret) {
                    ret = ret + "void <- (";
                    off = 0;
                } else {
                    ret = ret + SaacEditor.saac_type_render(t.getArray("actualTypeArguments").getObject(0));
                    ret = ret + " <- (";
                    off = 1;
                }
            } else {
                ret = ret + cls;
                ret = ret + "<";
            }
            DataArray ata = t.getArray("actualTypeArguments");
            for (int i = off; i < ata.size(); ++i) {
                if (i != off) {
                    ret = ret + ", ";
                }
                ret = ret + SaacEditor.saac_type_render(ata.getObject(i));
            }
            ret = ret + (subj_func ? ")" : ">");
            return ret;
        }
        if (t.has("genericComponentType")) {
            return SaacEditor.saac_type_render(t.getObject("genericComponentType")) + "[]";
        }
        if (t.has("class")) {
            return SaacEditor.shorten_type(t.getString("class"));
        }
        if (t.has("genericDeclaration")) {
            return "<" + t.getString("name") + ">";
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"unknown type ??: %s", (Object)t);
        return "??";
    }

    public static boolean saac_type_is_variadic(DataObject type) {
        if (type.has("genericComponentType")) {
            return true;
        }
        if (SaacEditor.saac_type_render(type).endsWith("[]")) {
            return true;
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"is_variadic? %s %s", (Object)SaacEditor.saac_type_render(type), (Object)type);
        return false;
    }

    public static boolean saac_is_function_descriptor(DataObject item) {
        return null != item && item.has("id") && item.has("name") && item.has("returning") && item.has("arguments");
    }

    public static void saac_validate_arguments(HTMLElement container) {
    }

    public static void saac_assert_valid_restore_data(DataObject data) {
    }

    public void saac_restore_function(DataObject data) {
        this.saac_restore_function(this.target, data);
    }

    public void saac_restore_function(HTMLElement container, DataObject data) {
        String id;
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Restoring public static void into container: %s %s", (Object)VanillaTools.getDomPath(container), (Object)data);
        HTMLElement f_ac = container.querySelector(".saac_function_autocomplete");
        String it = data.optString("it");
        if ("ta".equals(it)) {
            f_ac = VanillaTools.alterTag(f_ac, "textarea");
        }
        VanillaTools.setContent(f_ac, data.optString("content"));
        if ("ta".equals(it)) {
            SaacEditor.update_textarea_size(container.querySelector(".saac_function_autocomplete"));
        }
        this.saac_update_function_ac_input(f_ac);
        boolean pa = data.optBoolean("pa");
        if (pa) {
            container.querySelector(".saac_view_arguments_mode").click();
        }
        if (!"".equals(id = data.optString("id"))) {
            DataObject func = this.saac_get_function_by_id(id);
            if (null == func) {
                throw new RuntimeException("Invalid function id: " + id);
            }
            this.saac_function_container_set_function(container, func);
            if (data.has("args")) {
                this.saac_restore_function_arguments(container, data.getArray("args"));
            }
        }
    }

    protected static boolean isUsable(Object o) {
        return null != o && !StringTools.isNullOrTrimEmpty((String)o.toString());
    }

    public void saac_restore_function_arguments(HTMLElement container, DataArray args) {
        this.saac_ensure_arguments_container_function_container_count(container, args.size());
        NodeList ac = (NodeList)VanillaTools.getChildren(container.querySelector(".saac_f_arguments"));
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Restoring arguments %s %s", (Object)ac, (Object)args);
        for (int i = 0; i < ac.getLength(); ++i) {
            DataObject obj;
            HTMLElement subj = (HTMLElement)ac.get(i);
            Object elem = args.get(i);
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Restoring argument parameter %d, %s", (Object)i, (Object)subj, (Object)elem);
            if (elem instanceof DataObject && !SaacEditor.isUsable((obj = (DataObject)elem).get("id")) && !SaacEditor.isUsable(obj.get("content")) && obj.getArray("args").size() > 0) {
                elem = obj.getArray("args");
            }
            if (elem instanceof DataArray) {
                DataArray vs = (DataArray)elem;
                for (int n = 1; n < vs.size(); ++n) {
                    this.saac_add_varadic(subj);
                }
                NodeList target = (NodeList)VanillaTools.getChildren(subj.querySelector(".saac_arg_container"));
                for (int n = 0; n < vs.size(); ++n) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"restore varadic to container: %s %s %s %s", (Object[])new Object[]{target.get(n), vs.getObject(n), "in:", subj});
                    this.saac_restore_function((HTMLElement)target.get(n), vs.getObject(n));
                }
                continue;
            }
            if (!(elem instanceof DataObject)) continue;
            DataObject o = (DataObject)elem;
            this.saac_restore_function(SaacEditor.saac_find_container_dir_child(subj), o);
        }
    }

    public static HTMLElement saac_get_top_container(HTMLElement container) {
        return VanillaTools.whereParentWithBoundary(container, ".saac_entry_point", ".saac_entry_point");
    }

    public static boolean saac_is_container_in_use(HTMLElement container) {
        return !"".equals(((HTMLInputElement)container.querySelector(".saac_f_function_id")).getValue());
    }

    public static void saac_set_function_container_type(HTMLElement container, DataObject type) {
        String t = SaacEditor.saac_type_get_typeclass(type);
        ((HTMLInputElement)container.querySelector(".f_wrapper")).setValue(t);
        ((HTMLInputElement)container.querySelector(".saac_function_autocomplete")).setAttribute("placeholder", t);
    }

    public void saac_function_container_set_function(HTMLElement container, DataObject func) {
        String func_id = "";
        String wrapper_type = "";
        String ret_type = "";
        String func_descr = "";
        if (null != func) {
            func_id = func.optString("id");
            ret_type = SaacEditor.saac_type_render(func.getObject("returning").getObject("type"));
            func_descr = func.optString("descr");
        } else {
            ((HTMLInputElement)container.querySelector(".saac_function_autocomplete")).setValue("");
        }
        ((HTMLInputElement)container.querySelector(".saac_f_function_id")).setValue(func_id);
        ((HTMLInputElement)container.querySelector(".f_wrapper")).setValue(wrapper_type);
        VanillaTools.setInnerText(container.querySelector(".saac_f_ret_type"), ret_type);
        VanillaTools.setInnerText(container.querySelector(".saac_function_description"), func_descr);
        this.saac_ensure_argument_containers(container, null == func ? null : func.getArray("arguments"));
    }

    public static void saac_update_arg_infos(HTMLElement arg_container, DataObject arg_info) {
        HTMLElement pcont = arg_container.querySelector(".saac_function_container");
        if (!SaacEditor.saac_is_container_in_use(pcont)) {
            SaacEditor.saac_set_function_container_type(pcont, arg_info.getObject("type"));
        }
        if (SaacEditor.saac_type_is_variadic(arg_info.getObject("type"))) {
            VanillaTools.getClassList(arg_container).add("saac_arg_varadric");
        } else {
            VanillaTools.getClassList(arg_container).remove("saac_arg_varadric");
        }
        VanillaTools.setInnerText(arg_container.querySelector(".saac_arg_type"), SaacEditor.saac_type_render(arg_info.getObject("type")));
        VanillaTools.setInnerText(arg_container.querySelector(".saac_arg_name"), arg_info.getString("name"));
        VanillaTools.setInnerText(arg_container.querySelector(".saac_arg_descr"), arg_info.getString("description"));
    }

    public void saac_ensure_arguments_container_function_container_count(HTMLElement container, int creq) {
        HTMLElement tar_args = container.querySelector(".saac_f_arguments");
        int cnums = VanillaTools.getChildElementCount(tar_args);
        if (creq > cnums) {
            while (creq > cnums) {
                HTMLElement html = VanillaTools.parseHtml(SaacEditor.renderTemplate("saac/argument"));
                HTMLElement func = VanillaTools.parseHtml(SaacEditor.renderTemplate("saac/function_container"));
                html.querySelector(".saac_arg_container").appendChild((Node)func);
                tar_args.appendChild((Node)html);
                ++cnums;
            }
        }
        if (creq < cnums) {
            NodeList children = (NodeList)VanillaTools.getChildren(tar_args);
            for (int i = cnums - 1; i >= creq; --i) {
                if (SaacEditor.saac_is_container_in_use(((HTMLElement)children.get(i)).querySelector(".saac_arg_container"))) continue;
                VanillaTools.remove((Element)children.get(i));
            }
        }
    }

    public void saac_ensure_argument_containers(HTMLElement container, DataArray args) {
        HTMLElement tar_args = container.querySelector(".saac_f_arguments");
        int creq = null == args ? 0 : args.size();
        this.saac_ensure_arguments_container_function_container_count(container, creq);
        JSArray<HTMLElement> tarc = VanillaTools.getChildren(tar_args);
        for (int i = 0; i < creq; ++i) {
            SaacEditor.saac_update_arg_infos((HTMLElement)tarc.get(i), args.getObject(i));
        }
        SaacEditor.saac_validate_arguments(container);
    }

    public static HTMLElement saac_find_container_dir_parent(HTMLElement elem) {
        return VanillaTools.whereParentWithBoundary(elem, ".saac_function_container", ".saac_entry_point");
    }

    public static HTMLElement saac_find_container_dir_child(HTMLElement elem) {
        return elem.querySelector(".saac_function_container");
    }

    public static JSArray<HTMLElement> saac_find_container_dir_child_all(HTMLElement elem) {
        HTMLElement chk = elem.querySelector(".saac_function_container");
        if (null != chk) {
            JSArray<HTMLElement> cs = VanillaTools.getChildren((HTMLElement)chk.getParentNode());
            return cs;
        }
        return null;
    }

    public static JSArray<HTMLElement> saac_find_container_arguments(HTMLElement container) {
        HTMLElement args = container.querySelector(".saac_f_arguments");
        JSArray ret = JSArray.create();
        JSArray<HTMLElement> c = VanillaTools.getChildren(args);
        for (int i = 0; i < c.getLength(); ++i) {
            HTMLElement s = (HTMLElement)c.get(i);
            if (!VanillaTools.is(s, ".saac_argument")) continue;
            ret.push((JSObject)s);
        }
        return ret;
    }

    public void saac_add_varadic(HTMLElement container) {
        HTMLElement ac = container.querySelector(".saac_arg_container");
        HTMLElement func = VanillaTools.parseHtml(SaacEditor.renderTemplate("saac/function_container"));
        ac.appendChild((Node)func);
    }

    public void wipe_conainer(HTMLElement container) {
        JSArray<HTMLElement> c = SaacEditor.saac_find_container_arguments(container);
        for (int i = 0; i < c.getLength(); ++i) {
            VanillaTools.remove((Element)c.get(i));
        }
        this.saac_function_container_set_function(container, null);
    }

    public DataObject saac_get_function_by_id(String id) {
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
            NativeJsSupport.getSupport().log(this.saacFunctions);
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"saac_get_function_by_id(id: %s)", (Object)id);
        }
        if (null != id) {
            for (DataObject o : this.saacFunctions) {
                if (!id.equals(o.getString("id"))) continue;
                return o;
            }
        }
        return null;
    }

    public DataObject saac_get_function_by_name(String name) {
        for (DataObject o : this.saacFunctions) {
            if (!name.equals(o.getString("name"))) continue;
            return o;
        }
        return null;
    }

    public static int saac_determine_nth_arg_iam(HTMLElement container) {
        HTMLElement ac = VanillaTools.whereParentWithBoundary(container, ".saac_argument", ".saac_entry_point");
        if (null == ac) {
            return -1;
        }
        return VanillaTools.index(ac);
    }

    public DataObject saac_container_get_function(HTMLElement container) {
        String id = ((HTMLInputElement)container.querySelector(".saac_f_function_id")).getValue();
        return this.saac_get_function_by_id(id);
    }

    public static boolean __is_opt_set(int subject, int test) {
        return (subject & test) == test;
    }

    public static DataObject saac_serialize_container(HTMLElement container, SaacSerializationMode parent_mode, SaacSerializationMode child_mode) {
        if (null == container) {
            return null;
        }
        DataObjectTeaVMImpl ret = new DataObjectTeaVMImpl();
        ret.putString("id", ((HTMLInputElement)container.querySelector(".saac_f_function_id")).getValue());
        ret.putString("content", ((HTMLInputElement)container.querySelector(".autocomplete")).getValue());
        ret.putString("it", "TEXTAREA".equals(container.querySelector(".autocomplete").getNodeName()) ? "ta" : null);
        ret.putBoolean("pa", VanillaTools.getClassList(container.querySelector(".saac_view_arguments_mode")).contains("glyphicon-resize-horizontal"));
        if (SaacSerializationMode.NONE != parent_mode) {
            ret.putObject("parent", SaacEditor.saac_serialize_container(SaacEditor.saac_find_container_dir_parent(container), parent_mode == SaacSerializationMode.ALL ? SaacSerializationMode.ALL : SaacSerializationMode.NONE, SaacSerializationMode.NONE));
        }
        if (SaacSerializationMode.NONE != child_mode) {
            DataArray c = ret.newArrayInstance();
            JSArray<HTMLElement> chps = SaacEditor.saac_find_container_arguments(container);
            for (int n = 0; n < chps.getLength(); ++n) {
                HTMLElement argcont = (HTMLElement)chps.get(n);
                if (VanillaTools.is(argcont, ".saac_arg_varadric")) {
                    JSArray<HTMLElement> all = SaacEditor.saac_find_container_dir_child_all(argcont);
                    DataArray add = ret.newArrayInstance();
                    if (null != all) {
                        for (int i = 0; i < all.getLength(); ++i) {
                            add.putObject(SaacEditor.saac_serialize_container((HTMLElement)all.get(i), SaacSerializationMode.NONE, child_mode == SaacSerializationMode.ALL ? SaacSerializationMode.ALL : SaacSerializationMode.NONE));
                        }
                    }
                    DataObject o = c.newObjectInstance();
                    o.putArray("args", add);
                    o.putString("id", "");
                    o.putString("content", "");
                    c.putObject(o);
                    continue;
                }
                c.putObject(SaacEditor.saac_serialize_container(SaacEditor.saac_find_container_dir_child(argcont), SaacSerializationMode.NONE, child_mode == SaacSerializationMode.ALL ? SaacSerializationMode.ALL : SaacSerializationMode.NONE));
            }
            ret.putArray("args", c);
        }
        return ret;
    }

    protected static List<DataObject> extractFunctions(DataArray a) {
        ArrayList<DataObject> ret = new ArrayList<DataObject>();
        for (int i = 0; i < a.size(); ++i) {
            ret.add(a.getObject(i));
        }
        return ret;
    }

    public void synch_refresh_function_list() {
        DataArray src = this.rpc.listFunctions();
        this.saacFunctions = SaacEditor.extractFunctions(src);
    }

    public static void saac_update_container_validity(HTMLElement container) {
        VanillaTools.ClassList cl = VanillaTools.getClassList(container);
        cl.remove("saac_function_ok_assembly");
        cl.remove("saac_function_ok_runtime");
        cl.remove("saac_function_fail");
    }

    public void __saac_handle_autocomplete(HTMLElement container, final SimplePublish1<List<DataObject>> process) {
        String cls = ((HTMLInputElement)container.querySelector(".f_wrapper")).getValue();
        HTMLElement parentFunctionContainer = SaacEditor.saac_find_container_dir_parent(container);
        DataObject parentFunction = null;
        int nth_arg = -1;
        boolean varadic = false;
        if (null != parentFunctionContainer) {
            parentFunction = this.saac_container_get_function(parentFunctionContainer);
            nth_arg = SaacEditor.saac_determine_nth_arg_iam(container);
            varadic = VanillaTools.getClassList(VanillaTools.whereParentWithBoundary(container, ".saac_argument", ".saac_entry_point")).contains("saac_arg_varadric");
        } else {
            HTMLElement rootType = VanillaTools.whereParent(container, ".saac_entry_point").querySelector(".saac_root_accept_type");
            if (null != rootType) {
                String[] arr;
                String tr = VanillaTools.getInnerText(rootType);
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Found root type: %s", (Object)tr);
                if (null != tr && !"".equals(tr) && null != (arr = tr.split(":")) && arr.length > 1) {
                    parentFunction = this.saac_get_function_by_id(arr[0].trim());
                    nth_arg = Integer.parseInt(arr[1]);
                }
            }
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Offering request via autocomplete: (this: %s) parent function: %s arg:  %s", (Object)this, (Object)parentFunction, (Object)nth_arg);
        HTMLInputElement input = (HTMLInputElement)container.querySelector(".saac_function_autocomplete");
        if (null == parentFunction || nth_arg < 0) {
            process.publish(this.saacFunctions);
        } else {
            this.rpc.offerForType(new SimplePublish2<DataArray, JvxClientException>(){

                public void publish(DataArray a, JvxClientException b) {
                    process.publish(SaacEditor.extractFunctions(a));
                }
            }, null != parentFunction ? parentFunction.getString("id") : null, nth_arg, varadic, VanillaTools.getContent((HTMLElement)input), VanillaTools.getSelectionStart((HTMLElement)input), VanillaTools.getSelectionEnd((HTMLElement)input));
        }
    }

    public void saac_update_function_ac_input(HTMLElement input) {
        int min = ParsePrimitive.tryParseInt((String)input.getAttribute("data-originsize"), (int)5);
        int tar = ((HTMLInputElement)input).getValue().length() + 1;
        if (tar < min) {
            tar = min;
        }
        ((HTMLInputElement)input).setSize(tar);
    }

    public void __saac_bind_autocomplete(final HTMLElement elem) {
        final HTMLElement parent = SaacEditor.saac_find_container_dir_parent(elem);
        Autocomplete.AutocompleteSettings<DataObject> settings = new Autocomplete.AutocompleteSettings<DataObject>(elem, new SimplePublish2<String, SimplePublish1<List<DataObject>>>(){

            public void publish(String a, final SimplePublish1<List<DataObject>> b) {
                SaacEditor.this.__saac_handle_autocomplete(parent, new SimplePublish1<List<DataObject>>(){

                    public void publish(List<DataObject> a) {
                        String search = ((HTMLInputElement)elem).getValue().toLowerCase();
                        ArrayList<DataObject> arr = new ArrayList<DataObject>();
                        for (DataObject o : a) {
                            String s = o.optString("name");
                            if (null == s || s.toLowerCase().indexOf(search) <= -1) continue;
                            arr.add(o);
                        }
                        b.publish(arr);
                    }
                });
            }
        }, new SimplePublish3<Event, String, HTMLElement>(){

            public void publish(Event a, String b, HTMLElement c) {
                if (null == c) {
                    SaacEditor.this.saac_function_container_set_function(parent, null);
                } else {
                    SaacEditor.this.saac_function_container_set_function(parent, SaacEditor.this.saac_get_function_by_id(c.getAttribute("data-select-id")));
                }
            }
        });
        settings.renderItem = new GetBy2<HTMLElement, DataObject, String>(){

            public HTMLElement getBy(DataObject item, String b) {
                return new H("div").attrs("class", "autocomplete-suggestion", "data-select-id", item.getString("id"), "data-val", item.getString("name"), "#text", item.getString("name")).getHtml();
            }
        };
        settings.minChars = 0;
        new Autocomplete<DataObject>(settings);
        elem.listenKeyUp((EventListener)new EventListener<KeyboardEvent>(){

            public void handleEvent(KeyboardEvent arg0) {
                SaacEditor.this.saac_update_function_ac_input(elem);
            }
        });
    }

    public void __saac_add_eventlistener_autocomplete() {
        this.target.addEventListener("focus", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event event) {
                String wcls = "saac_typeahead_wired";
                HTMLElement target = (HTMLElement)event.getTarget();
                VanillaTools.ClassList cl = VanillaTools.getClassList(target);
                if (!cl.contains("saac_function_autocomplete")) {
                    return;
                }
                if (!cl.contains(wcls)) {
                    SaacEditor.this.__saac_bind_autocomplete(target);
                    cl.add(wcls);
                }
            }
        }, true);
    }

    public static void update_textarea_size(HTMLElement tar) {
    }

    public void __saac_add_eventlistener_textarea() {
        this.target.addEventListener("keyup", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event e) {
                HTMLElement tar = (HTMLElement)e.getTarget().cast();
                if ("TEXTAREA" != tar.getNodeName() || !VanillaTools.getClassList(tar).contains("saac")) {
                    return;
                }
                SaacEditor.update_textarea_size(tar);
            }
        });
    }

    public void __saac_add_eventlistener_argument_sortable() {
    }

    public void __do_copy_clipboard(HTMLElement target, boolean notify) {
        HTMLElement container;
        HTMLElement main = VanillaTools.whereParentWithBoundary(target, ".saac_entry_point, .saac_argument", ".saac_entry_point");
        if (null != main && null != (container = SaacEditor.saac_find_container_dir_child(main))) {
            DataObject ser = SaacEditor.saac_serialize_container(container, SaacSerializationMode.ALL, SaacSerializationMode.ALL);
            VanillaTools.copyToClipboard(JSON.stringify((JSObject)((JSObject)ser.getImpl())));
            if (notify) {
                this.notify_user("info", "M\u00e1solva a v\u00e1g\u00f3lapra");
            }
        }
    }

    public void __do_wipe_container(HTMLElement target, boolean notify) {
        HTMLElement container;
        HTMLElement main = VanillaTools.whereParentWithBoundary(target, ".saac_entry_point, .saac_argument", ".saac_entry_point");
        if (null != main && null != (container = SaacEditor.saac_find_container_dir_child(main))) {
            this.wipe_conainer(container);
            if (notify) {
                this.notify_user("info", "Elj\u00e1r\u00e1s elt\u00e1vol\u00edtva");
            }
        }
    }

    public void __do_cut_clipboard(HTMLElement target) {
        this.__do_copy_clipboard(target, false);
        this.__do_wipe_container(target, false);
        this.notify_user("info", "Elj\u00e1r\u00e1s \u00e1thelyezve a v\u00e1r\u00f3lapra");
    }

    public void __do_server_execute(SaacApi RPC, HTMLElement target) {
        HTMLElement container;
        HTMLElement main = VanillaTools.whereParentWithBoundary(target, ".saac_entry_point", ".saac_entry_point");
        if (null != main && null != (container = SaacEditor.saac_find_container_dir_child(main))) {
            RPC.execute(new SimplePublish2<DataObject, JvxClientException>(){

                public void publish(DataObject ret, JvxClientException error) {
                    if (null != error) {
                        SaacEditor.this.notify_user("error", "Szerver oldali hiba t\u00f6rt\u00e9nt: " + error);
                    } else if (null != ret) {
                        SaacEditor.this.notify_user("info", "Szerver oldali futtat\u00e1s megkezdve.");
                    } else {
                        SaacEditor.this.notify_user("error", "Bels\u0151 hiba t\u00f6rt\u00e9nt, r\u00e9szletek\u00e9rt l\u00e1sd a javascript konzolt.");
                    }
                }
            }, SaacEditor.saac_serialize_container(container, SaacSerializationMode.ALL, SaacSerializationMode.ALL));
        }
    }

    public void __do_varadic_add(HTMLElement target) {
        this.saac_add_varadic(VanillaTools.whereParentWithBoundary(target, ".saac_argument", ".saac_entry_point"));
    }

    public void __do_varadic_remove(HTMLElement target) {
        VanillaTools.remove((Element)VanillaTools.whereParentWithBoundary(target, ".saac_function_container", ".saac_entry_point"));
    }

    public void __do_arguments_viewmode_switch(HTMLElement target) {
        VanillaTools.changeClass(target, "glyphicon-resize-vertical", "glyphicon-resize-horizontal");
        HTMLElement container = SaacEditor.saac_find_container_dir_parent(target);
        VanillaTools.ClassList cl = VanillaTools.getClassList(target);
        if (cl.contains("glyphicon-resize-horizontal")) {
            cl.add("saac_viewmode_horizontal");
        } else {
            cl.remove("saac_viewmode_horizontal");
        }
    }

    public void __do_show_console(HTMLElement target) {
    }

    public void __saac_add_eventlistener_clicks() {
        this.target.addEventListener("click", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event event) {
                HTMLElement target = (HTMLElement)event.getTarget().cast();
                VanillaTools.ClassList cl = VanillaTools.getClassList(target);
                if (!cl.contains("saac")) {
                    return;
                }
                if (cl.contains("saac_operation_all_clipboard")) {
                    SaacEditor.this.__do_copy_clipboard(target, true);
                } else if (cl.contains("saac_operation_remove")) {
                    SaacEditor.this.__do_wipe_container(target, true);
                } else if (cl.contains("saac_operation_clipboard_cut")) {
                    SaacEditor.this.__do_cut_clipboard(target);
                } else if (cl.contains("saac_operation_execute")) {
                    SaacEditor.this.__do_server_execute(SaacEditor.this.rpc, target);
                } else if (cl.contains("saac_varadic_add")) {
                    SaacEditor.this.__do_varadic_add(target);
                } else if (cl.contains("saac_varadic_remove")) {
                    SaacEditor.this.__do_varadic_remove(target);
                } else if (cl.contains("saac_view_arguments_mode")) {
                    SaacEditor.this.__do_arguments_viewmode_switch(target);
                } else if (cl.contains("saac_operation_show_console") && !cl.contains("saac_disabled")) {
                    SaacEditor.this.__do_show_console(target);
                }
            }
        });
    }

    public void __do_funtion_paste(String data) {
        try {
            HTMLElement container = null;
            container = VanillaTools.getClassList(this.target).contains("saac_function_container") ? this.target : SaacEditor.saac_find_container_dir_parent(this.target);
            DataObjectTeaVMImpl json = new DataObjectTeaVMImpl(JSON.parse((String)data));
            SaacEditor.saac_assert_valid_restore_data((DataObject)json);
            this.__do_wipe_container(container, false);
            this.saac_restore_function(container, (DataObject)json);
            this.notify_user("info", "Sikeres beilleszt\u00e9s");
        }
        catch (Exception err) {
            this.notify_user("error", err.getMessage());
            throw err;
        }
    }

    public void __saac_add_eventlistener_paste() {
    }

    public void __saac_add_eventlistener_input_type() {
        this.target.addEventListener("click", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event event) {
                HTMLElement target = (HTMLElement)event.getTarget().cast();
                VanillaTools.ClassList cl = VanillaTools.getClassList(target);
                if (!cl.contains("saac_function_autocomplete")) {
                    return;
                }
                if (((EventExtra)event).isCtrlKey()) {
                    event.preventDefault();
                    if (target.getNodeName().equals("INPUT")) {
                        VanillaTools.alterTag(target, "textarea");
                    } else {
                        cl.remove("saac_typeahead_wired");
                        VanillaTools.alterTag(target, "input");
                    }
                }
            }
        });
    }

    public static void __saac_init_show_menu(HTMLElement container, String cls_selector, boolean bool_show) {
        if (null != container && null != cls_selector) {
            HTMLElement tar = container.querySelector(cls_selector);
            VanillaTools.ClassList cl = VanillaTools.getClassList(tar);
            if (null != tar) {
                if (bool_show) {
                    cl.remove("saac_no_show");
                } else {
                    cl.add("saac_no_show");
                }
            }
        }
    }

    public SaacAcceptType __saac_init_conf_get_root_type(SaacConfig cfg) {
        if (null != cfg && null != cfg.rootType) {
            DataObject func = this.saac_get_function_by_id(cfg.rootType.func);
            if (null == func) {
                String errmsg = "function does'nt exists: " + cfg.rootType.func;
                System.err.println(errmsg);
                throw new RuntimeException(errmsg);
            }
            int index = cfg.rootType.argIndex;
            if (index < 0 || index >= func.getArray("arguments").size()) {
                String errmsg = "function ('" + func.getString("name") + "') accepts only " + func.getArray("arguments").size() + " arguments (length), " + index + " (index) given";
                System.err.println(errmsg);
                throw new RuntimeException(errmsg);
            }
            return new SaacAcceptType(func, index);
        }
        return null;
    }

    public DataObject serialize() {
        return SaacEditor.saac_serialize_container(SaacEditor.saac_find_container_dir_child(this.target), SaacSerializationMode.ALL, SaacSerializationMode.ALL);
    }

    public void __saac_init_options_visibility(HTMLElement root, SaacConfig cfg) {
        if (null != cfg && null != cfg.show) {
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_remove", cfg.show.clear);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_clipboard_cut", cfg.show.cut);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_insert_from_clipboard", cfg.show.insert);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_all_clipboard", cfg.show.copy);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_save", cfg.show.save);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_execute", cfg.show.execute);
            SaacEditor.__saac_init_show_menu(root, ".saac_operation_show_console", cfg.show.console);
            SaacEditor.__saac_init_show_menu(root, ".saac_project_file_container", cfg.show.browser);
            SaacEditor.__saac_init_show_menu(root, ".saac_primary_container", cfg.show.editor);
        }
        if (null != cfg && cfg.embedConsole) {
            SaacEditor.__saac_init_show_menu(root, ".saac_hidden_console_content", cfg.embedConsole);
        }
        this.__saac_add_eventlistener_autocomplete();
        this.__saac_add_eventlistener_argument_sortable();
        this.__saac_add_eventlistener_clicks();
        this.__saac_add_eventlistener_paste();
        this.__saac_add_eventlistener_input_type();
        this.__saac_add_eventlistener_textarea();
    }

    public HTMLElement saac_get_console_root(HTMLElement container) {
        HTMLElement tar = container.querySelector(".saac_console_root");
        if (null != tar) {
            return tar;
        }
        return this.consoleDom;
    }

    public HTMLElement saac_get_log_container(HTMLElement container) {
        return this.saac_get_console_root(container).querySelector(".saac_log_container");
    }

    public static void saac_dispatch_server_event(HTMLElement container, DataObject packet) {
    }

    public static SaacEditor saac_initEntryPoint(HTMLElement root, SaacConfig cfg) {
        SaacEditor ret = new SaacEditor(root, cfg);
        ret.synch_refresh_function_list();
        SaacAcceptType root_type = ret.__saac_init_conf_get_root_type(cfg);
        if (null != root_type) {
            VanillaTools.setInnerText(root.querySelector(".saac_root_accept_type"), root_type.func);
            VanillaTools.setInnerText(root.querySelector(".saac_root_type_name"), SaacEditor.saac_type_render(root_type.type));
        }
        ret.__saac_init_options_visibility(root, cfg);
        root.querySelector(".saac_primary_container").appendChild((Node)VanillaTools.parseHtml(SaacEditor.renderTemplate("saac/function_container")));
        return ret;
    }

    public static SaacEditor saac_createEntryPoint(HTMLElement ROOT, SaacConfig cfg) {
        HTMLElement tar = VanillaTools.parseHtml(SaacEditor.renderTemplate("saac/main"));
        ROOT.appendChild((Node)tar);
        return SaacEditor.saac_initEntryPoint(tar, cfg);
    }

    public void ensureInitalized(SimplePublish1<SaacEditor> onReady) {
        this.synch_refresh_function_list();
        if (null != onReady) {
            onReady.publish((Object)this);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SaacEditor: " + this.name;
    }

    static {
        VanillaTools.addCssRules(".saac saac_primary_container > .saac saac_function_container > .saac_varadic_remove {display:none}", "textarea.saac {tab-size: 4;}", ".saac {display: inline-block;transition: all 0.3s cubic-bezier(.25,.8,.25,1);vertical-align: top;}", "button.glyphicon { border:none; background-color: white; margin: 3px;}", ".saac.saac_no_show {display:none !important;}", ".saac.saac_hidden_console_content {display:block;}", ".saac_menubar {display: block;font-size: 25px;margin-bottom: 15px;}", ".saac_menubar > *,.saac_argument_menu > * {padding: 10px;box-shadow: 0 3px 5px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);}", ".saac_menubar > *:hover,.saac_argument_menu > *:hover {box-shadow: 0 7px 15px rgba(0,0,0,0.25), 0 7px 16px rgba(0,0,0,0.22);}", ".saac.glyphicon.saac_disabled {background-color: grey;color: white;}", ".saac_operation_insert_from_clipboard {position: relative;}", ".saac_operation_insert_from_clipboard textarea {position: absolute;top: 0;right: 0;margin: 0;padding: 0;cursor: pointer;opacity: 0;width: 100%;height: 100%;}", ".saac_operation_insert_from_clipboard.active {border: 3px solid blue;padding: 7px;}", ".saac_argument_menu {display:inline-block;margin: 3px;}", ".saac_argument_menu > * {display:none;margin-bottom: 6px;padding: 3px;font-size: 18px;}", ".saac_argument_menu > .saac_show_menu {display:inline-block;/*font-size: 10px;*/}", ".saac_argument_menu:hover > .saac_show_menu {display:none;}", ".saac_argument_menu:hover > * {/*display:inline-block;*/display:block;}", ".saac_varadic_remove,.saac_varadic_add {display: inline-block;margin-bottom: 6px;padding: 3px;font-size: 18px;align:center;}", ".saac_argument.saac_arg_varadric > .saac_argument_variadic_menu,.saac_argument.saac_arg_varadric > .saac_arg_container> .saac_function_container > .saac_varadic_remove {display: block;}", ".saac_argument.saac_arg_varadric > .saac_arg_container> .saac_function_container > .saac_varadic_remove,.saac_argument_variadic_menu,.saac_varadic_remove {display: inline-block;vertical-align: center;}", ".saac_menubar,.saac_function_container > * {vertical-align: top;}", ".saac_function_autocomplete {margin-left:20px;}", ".saac_function_description {display: block;color: rgba(0, 67, 255, 0.72);}", ".saac_function_container {box-shadow: 0 3px 5px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);display: block;}", ".saac_arg_container {display: inline-block;}", ".saac_f_arguments {display: block;padding: 5px;}", ".saac_argument {display: block;box-shadow: 0 3px 5px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);margin-left: 5px;margin-top: 5px;}", ".saac_function_container.saac_viewmode_horizontal> .saac_f_arguments> .saac_argument {display:inline-block;}", ".saac_function_ok_assembly {background-color: lightgreen;}", ".saac_function_ok_runtime {background-color: lightyellow;}", ".saac_function_fail {background-color: lightred;}", ".saac_f_ret_type,.saac_arg_type {font-size: 12px;color: #C27331;display: inline-block;}", ".saac_arg_name {font-size: 13px;color:grey;}", ".saac_arg_descr {color: #5A5A5A;}", ".saac_function_autocomplete {color:#000000;font-weight: bold;font-size:16px;}", ".saac.saac_arg_descr,.saac.saac_arg_name,.saac.saac_f_ret_type {vertical-align: sub;}", ".saac_f_arguments {display: inline-block}", ".saac_overview_mode .saac_function_description,.saac_overview_mode .saac_show_menu {display:none;}", ".saac_overview_mode .saac_f_arguments:hover .saac_function_description,.saac_overview_mode .saac_f_arguments:hover .saac_show_menu {display:inline-block;}", ".saac-minimal .saac_f_ret_type, .saac-minimal .saac_arg_descr, .saac-minimal .saac_view_arguments_mode, .saac-minimal .saac_argument_menu, .saac-minimal .saac_menubar {display:none}", ".saac-minimal .saac_varadic_remove {display:inline-block;}", ".saac-minimal .saac_function_autocomplete {margin-left: 5px}");
    }

    public static class SaacConfig {
        public SaacRootType rootType;
        public SaacMenuVisiblity show = new SaacMenuVisiblity();
        public boolean embedConsole;
        public SaacApi api;
        public SimplePublish2<String, String> customNotify;
    }

    public static class SaacMenuVisiblity {
        public boolean clear = true;
        public boolean cut = true;
        public boolean insert = true;
        public boolean copy = true;
        public boolean save = true;
        public boolean execute = true;
        public boolean console = true;
        public boolean browser = true;
        public boolean editor = true;
    }

    public static class SaacRootType {
        public final String func;
        public final int argIndex;

        public SaacRootType(String func, int index) {
            this.func = func;
            this.argIndex = index;
        }
    }

    protected static class SaacAcceptType {
        public final String func;
        public final DataObject type;

        public SaacAcceptType(DataObject func, int index) {
            this.func = func.getString("id") + ":" + index;
            this.type = func.getArray("arguments").getObject(index).getObject("type");
        }
    }

    protected static abstract class EventExtra
    implements JSObject {
        protected EventExtra() {
        }

        @JSProperty
        public abstract boolean isCtrlKey();
    }

    public static enum SaacSerializationMode {
        NONE,
        DIRECT,
        ALL;

    }

    public static class SaacType {
        public SaacType genericComponentType;
    }
}

