/*
 * Decompiled with CFR 0.152.
 */
package eu.teasite.frontend.api.transfers;

import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.reflect.Mirror;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.MessageEvent;
import org.teavm.jso.websocket.CloseEvent;
import org.teavm.jso.websocket.WebSocket;

public class ManagedWebSocket {
    protected String url;
    protected WebSocket websocket;
    protected Boolean connected;
    protected EventMediator<Boolean> connectionStateChange = new EventMediator();

    public ManagedWebSocket(String url) {
        this.websocket = WebSocket.create(url);
        this.websocket.onOpen((EventListener<MessageEvent>)((EventListener)msg -> this.onConnectionStateChange(true)));
        this.websocket.onClose((EventListener<CloseEvent>)((EventListener)msg -> this.onConnectionStateChange(false)));
    }

    private void onConnectionStateChange(boolean b) {
        this.connected = b;
        this.connectionStateChange.dispatchEvent((Object)this.connected);
    }

    protected static void sleep(int t) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Mirror.propagateAnyway((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitConnect() {
        while (true) {
            ManagedWebSocket.sleep(100);
            ManagedWebSocket managedWebSocket = this;
            synchronized (managedWebSocket) {
                if (null != this.connected) {
                    return this.connected;
                }
            }
        }
    }

    public WebSocket getWebSocket() {
        return this.websocket;
    }

    public static ManagedWebSocket openConnection(String url) {
        ManagedWebSocket ret = new ManagedWebSocket(url);
        boolean conn = ret.waitConnect();
        if (conn) {
            return ret;
        }
        return null;
    }

    public EventMediator<Boolean> getConnectionStateListener() {
        return this.connectionStateChange;
    }
}

