/*
 * Decompiled with CFR 0.152.
 */
package eu.teasite.frontend.api.transfers;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.retry.RetryTools;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.teasite.frontend.api.transfers.ApiPacketTransfer;
import eu.teasite.frontend.api.transfers.ManagedWebSocket;
import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.MessageEvent;
import org.teavm.jso.json.JSON;
import org.teavm.jso.websocket.WebSocket;

public class WebSocketTransfer
extends ApiPacketTransfer {
    protected ManagedWebSocket websocket;
    protected String url;
    protected Boolean connected;
    protected SimplePublish1<DataObject> serverEvents;
    protected EventMediator<Boolean> connectionStateChange = new EventMediator();
    protected long id = 0L;
    protected Map<String, WebSocketPendingRequest> pendingResponses = new HashMap<String, WebSocketPendingRequest>();

    protected void acceptSocket(ManagedWebSocket ws) {
        this.connected = null;
        this.websocket = ws;
        this.websocket.getWebSocket().onMessage((EventListener<MessageEvent>)((EventListener)this::onMessage));
        this.websocket.getConnectionStateListener().addEventListener(arg_0 -> this.connectionStateChange.dispatchEvent(arg_0));
        this.connected = true;
        this.connectionStateChange.dispatchEvent((Object)true);
    }

    protected void resendRequests() {
        WebSocket ws = this.websocket.getWebSocket();
        for (WebSocketPendingRequest pr : this.pendingResponses.values()) {
            pr.send(ws);
        }
    }

    public static WebSocketTransfer connectPath(String path) {
        return new WebSocketTransfer("ws://" + Window.current().getLocation().getHost() + path);
    }

    public WebSocketTransfer(String url) {
        this.url = url;
        this.reconnect();
    }

    protected ManagedWebSocket reconnectSocket() {
        ManagedWebSocket ret = ManagedWebSocket.openConnection(this.url);
        if (null == ret) {
            throw new RuntimeException("Can't connect");
        }
        return ret;
    }

    public void reconnect() {
        SimpleGet reconn = RetryTools.waitReconnect(() -> this.reconnectSocket(), (String)"WebSocket");
        this.acceptSocket((ManagedWebSocket)reconn.get());
        this.resendRequests();
    }

    protected synchronized void onConnectionStateChange(boolean conn) {
        if (this.connected != Boolean.valueOf(conn)) {
            this.connected = conn;
            this.connectionStateChange.dispatchEvent((Object)conn);
        }
    }

    protected void onMessage(MessageEvent msg) {
        WebSocketPendingRequest pending;
        DataObjectTeaVMImpl obj = new DataObjectTeaVMImpl(JSON.parse((String)msg.getDataAsString()));
        String trace = obj.optString("t");
        if (null != trace && null != (pending = this.pendingResponses.remove(trace)) && null != pending.handler) {
            pending.handler.publish((Object)obj);
            return;
        }
        if (null != this.serverEvents) {
            this.serverEvents.publish((Object)obj);
        }
    }

    @Override
    protected void transmitAsync(DataObject req, SimplePublish1<DataObject> resp) {
        String trace = String.valueOf(++this.id);
        req.putString("t", trace);
        WebSocketPendingRequest wspr = new WebSocketPendingRequest(req, trace, resp);
        this.pendingResponses.put(trace, wspr);
        wspr.send(this.websocket.getWebSocket());
    }

    public void setServerEventListener(SimplePublish1<DataObject> serverEvents) {
        this.serverEvents = serverEvents;
    }

    public EventMediator<Boolean> getConnectionStateListener() {
        return this.connectionStateChange;
    }

    public void setAutoReconnect() {
        this.connectionStateChange.addEventListener(e -> {
            if (Boolean.FALSE == e) {
                System.out.println("disconnected: reconnect");
                new Thread(){

                    @Override
                    public void run() {
                        WebSocketTransfer.this.reconnect();
                    }
                }.start();
            } else {
                this.resendRequests();
            }
        });
    }

    protected class WebSocketPendingRequest {
        public DataObject request;
        public String traceId;
        public SimplePublish1<DataObject> handler;

        public WebSocketPendingRequest(DataObject req, String trace, SimplePublish1<DataObject> resp) {
            this.request = req;
            this.traceId = trace;
            this.handler = resp;
        }

        public void send(WebSocket ws) {
            ws.send(JSON.stringify((JSObject)((JSObject)this.request.getImpl())));
        }
    }
}

