package eu.javaexperience.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.dom.build.WebSoftwareBundle;

public enum CdnFramework implements WebSoftwareBundle
{
	Jquery__2_2_4
	(
		a("https://code.jquery.com/jquery-2.2.4.min.js"),
		a(),
		a()
	),
	
	Boostrap__3_3_7
	(
		a("https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"),
		a("https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css"),
		a()
	),
	
	Bs_typeahead__4_0_2
	(
		a("https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.2/bootstrap3-typeahead.min.js"),
		a(),
		a()
	),
	
	Jq_toastr__2_1_3
	(
		a("https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"),
		a("https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"),
		a()
	),
	
	Mustache__2_3_0
	(
		a("https://cdnjs.cloudflare.com/ajax/libs/mustache.js/2.3.0/mustache.min.js"),
		a(),
		a()
	),
	
	sweetAlert2
	(
		a("https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.0.6/sweetalert2.all.min.js"),
		a("https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.0.6/sweetalert2.min.css"),
		a()
	),
	
	
	GridManager__2_4_0
	(
		a("/resource/cdn/gridmanager/jquery.gridmanager.min.js"),
		a("/resource/cdn/gridmanager/jquery.gridmanager.css"),
		a()
	),
	
	
	JQueryUi__1_12_0
	(
		a("https://code.jquery.com/ui/1.12.0/jquery-ui.min.js"),
		a("https://code.jquery.com/ui/1.12.0/themes/smoothness/jquery-ui.css"),
		a()
	),
	
	
	Boostrap__4_1
	(
		a("//cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js", "//stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js"),
		a("//stackpath.bootstrapcdn.com/bootstrap/4.1.1/css/bootstrap.min.css"),
		a()
	),
	
	/*requires moment js: Boostrap_datetimepicker_4_17_47
	(
		a("//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"),
		a("//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css"),
		a()
	),*/
	
	
	
	;
	
	protected static String[] a()
	{
		return Mirror.emptyStringArray;
	}
	
	protected static String[] a(String... a)
	{
		return a;
	}
	
	protected List<String> lCss;
	protected List<String> lPreJs;
	protected List<String> lPostJs;
	
	private CdnFramework(String[] preJs, String[] css, String[] postJs)
	{
		this.preJs = preJs;
		this.css = css;
		this.postJs = postJs;
		
		lCss = Collections.unmodifiableList(Arrays.asList(css));
		lPreJs = Collections.unmodifiableList(Arrays.asList(preJs));
		lPostJs = Collections.unmodifiableList(Arrays.asList(postJs));
	}
	
	public String[] preJs;
	public String[] css;
	public String[] postJs;
	
	protected static void appendLabel(StringBuilder sb, String var, String[] arr, boolean hasNext)
	{
		sb.append("\t\t");
		sb.append(var);
		sb.append(": [");
		int i=0;
		for(String s:arr)
		{
			if(++i > 1)
			{
				sb.append(", ");
			}
			sb.append("\"");
			sb.append(s);
			sb.append("\"");
		}
		
		sb.append("]");
		if(hasNext)
		{
			sb.append(",");
		}
		
		sb.append("\n");
	}
	
	public static String exportToJs()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("CDN_RESOURCES = new function()\n{\n");
		for(CdnFramework fw: values())
		{
			sb.append("\tthis.");
			sb.append(fw.name());
			sb.append(" = \n\t{\n");
			appendLabel(sb, "css", fw.css, true);
			appendLabel(sb, "preJs", fw.preJs, true);
			appendLabel(sb, "postJs", fw.postJs, false);
			sb.append("\t};\n\n");
		}
		
		sb.append("};\n\n");
		
		return sb.toString();
	}
	
	@Override
	public List<String> getCss()
	{
		return lCss;
    }

	@Override
	public List<String> getPreJs()
	{
		return lPreJs;
	}

	@Override
	public List<String> getPostJs()
	{
		return lPostJs;
	}
}