package eu.javaexperience.web;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacility.SiteObjectSettings;
import eu.javaexperience.web.fw.TemplateWebsite;
import eu.javaexperience.web.server.binding.HttpSocketProtocol;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.Lightning;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.session.InMemorySessionManager;
import eu.javaexperience.web.session.SessionTools;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;

import static eu.javaexperience.web.TemplateWebsiteTools.*;

public abstract class TemplateWebsiteServer
{
	protected GetBy1<ServiceProcessHooks, ServiceProcessHooks> hookModifier;
	
	protected void hook_rightBeforeFinishOperation(Context ctx)
	{
		
	}
	
	protected void hook_onSessionRefreshLastUse(Session a, Context b)
	{
		
	}
	
	protected void hook_beforeRequestDispatchStart(Context ctx)
	{
		
	}
	
	protected void hook_beforeHeaderSent(Context ctx)
	{
		
	}
	
	protected Boolean hook_applyView(Context ctx)
	{
		Map<String, Object> obj = ctx.getEnv();
		if(null != obj)
		{
			Map<String, Object> VIEW = (Map<String, Object>) obj.get("VIEW");
			if(null != VIEW)
			{
				Object root = VIEW.get("root");
				Template t  = null;
				
				if(root instanceof Template)
				{
					t = (Template) root;
				}
				else if(root instanceof String)
				{
					t = getContextTemplateFw(ctx).WEB_CONTEXT.getView((String) root);
				}
				
				if(null != t)
				{
					try
					{
						t.render(ctx, ctx.getResponse().getWriter());
					}
					catch (IOException e)
					{
						Mirror.propagateAnyway(e);
					}
					return Boolean.TRUE;
				}
			}
		}
		return Boolean.FALSE;
	}
	
	protected void unservedRequest(Context ctx)
	{
	
	}
	
	protected void hook_afterRequestEnd(Context ctx)
	{
		
	}
	
	protected Map<String, Object> hook_wrapContextForRender(Context ctx, Map<String, Object> env)
	{
		return env;
	}
	
	protected void hook_exceptionProcess(Context ctx)
	{
		Throwable t = ctx.getProcessException();
		if(null != t)
		{
			ctx.getEnv().put("exception", t);
		}
	}
	
	protected SiteObjectSettings generateConfiguration()
	{
		SiteObjectSettings ret = new SiteObjectSettings();
		
		ret.sessionCookieName = "jvx-session";
		
		ret.sessionManager = createSessionManager();
		
		ret.templateManager = createDefaultTemplateManager(); 
				
				//RazorTemplateManager.loadViewsFromDir(Format.toString(Global.getProperty("template_dir")));
		
		ServiceProcessHooks hooks = HOOKS;
		if(null != hookModifier)
		{
			hooks = hookModifier.getBy(hooks);
		}
		
		ret.createContext = TemplateWebsiteTools.generateContextCreatorWithHooks(hooks);
		
		ret.beforeRequestProcess = new SimplePublish1<Context>()
		{
			/**
			 * A kérés kiszolgálása előtt beállítjuk az alapértelmezett
			 * gyökérsablont
			 * */
			@Override
			public void publish(Context ctx)
			{
				initRequest(ctx);
			}
		};
		
		ret.beforeViewApply = TemplateWebsite.beforeViewApplyLightningLogTemplateCompilationStartTime;
		
		ret.afterRequestEnd = TemplateWebsite.logAfterRequestEnd(new SimpleGet<Appendable>()
		{
			@Override
			public Appendable get()
			{
				return System.out;
			}
		});
		
		
		ret.exceptionHandler = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context ctx)
			{
				hook_exceptionProcess(ctx);
			}
		};
		
		ret.unserved = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context a)
			{
				unservedRequest(a);
			}
		};
		
		return ret;
	}
	
	
	protected SessionManager createSessionManager()
	{
		return new InMemorySessionManager();
	}
	
	
	protected final static ServiceProcessHooks HOOKS = new ServiceProcessHooks()
	{
		SimplePublish1<Context> rightBeforeFinishOperation = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context a)
			{
				getContextTemplateFw(a).TEMPLATE.hook_rightBeforeFinishOperation(a);
			}
		};
		
		@Override
		public SimplePublish1<Context> rightBeforeFinishOperation()
		{
			return rightBeforeFinishOperation;
		}
		
		SimplePublish2<Session, Context> onSessionRefreshLastUse = new  SimplePublish2<Session, Context>()
		{
			@Override
			public void publish(Session a, Context b)
			{
				getContextTemplateFw(b).TEMPLATE.hook_onSessionRefreshLastUse(a, b);
			}
		};
		
		@Override
		public SimplePublish2<Session, Context> onSessionRefreshLastUse()
		{
			return onSessionRefreshLastUse;
		}
		
		SimplePublish1<Context> beforeRequestDispatchStart = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context a)
			{
				getContextTemplateFw(a).TEMPLATE.hook_beforeRequestDispatchStart(a);
			}
		};
		
		@Override
		public SimplePublish1<Context> beforeRequestDispatchStart()
		{
			return beforeRequestDispatchStart;
		}
		
		SimplePublish1<Context> beforeHeaderSent = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context a)
			{
				getContextTemplateFw(a).TEMPLATE.hook_beforeHeaderSent(a);
			}
		};
		
		
		@Override
		public SimplePublish1<Context> beforeHeaderSent()
		{
			return beforeHeaderSent;
		}
		
		protected GetBy1<Boolean, Context> apply = new GetBy1<Boolean, Context>()
		{
			@Override
			public Boolean getBy(Context ctx)
			{
				return getContextTemplateFw(ctx).TEMPLATE.hook_applyView(ctx);
			}
		};
		
		@Override
		public GetBy1<Boolean, Context> applyView()
		{
			return apply;
		}
		
		SimplePublish1<Context> afterRequestEnd = new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context a)
			{
				getContextTemplateFw(a).TEMPLATE.hook_afterRequestEnd(a);
			}
		};
		
		
		@Override
		public SimplePublish1<Context> afterRequestEnd()
		{
			return afterRequestEnd;
		}
		
		GetBy2<Map<String, Object>, Context, Map<String, Object>> wrapContextForRender = new GetBy2<Map<String, Object>, Context, Map<String, Object>>()
		{
			@Override
			public Map<String, Object> getBy(Context ctx, Map<String, Object> a)
			{
				return getContextTemplateFw(ctx).TEMPLATE.hook_wrapContextForRender(ctx, a);
			}
		};

		@Override
		public GetBy2<Map<String, Object>, Context, Map<String, Object>> wrapContextForRender()
		{
			return wrapContextForRender;
		}
	};
	
	protected IOStreamServer getWebServerSocket() throws IOException
	{
		return IOStreamFactory.fromServerSocket(new ServerSocket(5555));
	}
	
	/*protected void addDefaultDispatcher(SiteObject WEB_CONTEXT)
	{
		WEB_CONTEXT.addRootDispatcher(DefaultDispatch.getDispatcher());
	}*/
	
	protected void addDispatchers(SiteFacility WEB_CONTEXT, Dispatcher<Context> dispatch)
	{
		WEB_CONTEXT.addRootDispatcher(dispatch);
	}
	
	public final TemplateWebsiteContext WEB_CTX;
	
	public final Lightning<IOStream> SERVER;
	
	protected final Dispatcher<Context> dispatcher;
	
	public Dispatcher<Context> getDispatcher()
	{
		return dispatcher;
	}
	
	public TemplateWebsiteServer(Dispatcher<Context> dispatcher) throws IOException
	{
		SiteFacility WEB_CONTEXT = new SiteFacility(generateConfiguration());
		
		this.dispatcher = dispatcher;
		addDispatchers(WEB_CONTEXT, dispatcher);
		
		SERVER = new Lightning<IOStream>
		(
			getWebServerSocket(),
			getHttpProtocol(),
			10,
			WEB_CONTEXT
		);
		
		SERVER.setKeepAlive(false);
		SERVER.setMaxConnectionPerIp(0);
		
		
		WEB_CTX = new TemplateWebsiteContext(SERVER, WEB_CONTEXT, this);
	}
	
	public HttpSocketProtocol getHttpProtocol()
	{
		return WellKnownSocketHttpProtocol.RAW_HTTP;
	}
	
	public String getSessionCookieName()
	{
		return WEB_CTX.getWebContext().getSessionCookieName();
	}
	
	public abstract TemplateManager createDefaultTemplateManager();
	
	public boolean needSessionStart(Context ctx)
	{
		return true;
	}
	
	public static final String TEMPLATE_WEBSITE_FRAMEWORK_KEY = "SYS_TWFW";
	
	public void initRequest(Context ctx)
	{
		Map<String, Object> ENV = ctx.getEnv();
		ENV.put(TEMPLATE_WEBSITE_FRAMEWORK_KEY, WEB_CTX);
		if(needSessionStart(ctx))
		{
			SessionManager sm = WEB_CTX.WEB_CONTEXT.getSessionManager();
			if(null != sm)
			{
				SessionTools.sessionStart(sm, getSessionCookieName(), ctx);
			}
		}
		
		ENV.put("VIEW", new SmallMap<>());
	}
	
	public void start()
	{
		WEB_CTX.SERVER.start();
	}
}
