package eu.javaexperience.web;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.NullCollection;
import eu.javaexperience.collection.list.PrettyPrintArrayList;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.dispatch.DefaultDispatchStructure;
import eu.javaexperience.web.dispatch.WebDispatchTools;
import eu.javaexperience.web.dispatch.url.AttachDirectoryURLNode;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.fw.SiteObjectTools;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;

public class TemplateWebsiteTools
{
	public static TemplateWebsiteContext getContextTemplateFw(Context ctx)
	{
		TemplateWebsiteContext ret = (TemplateWebsiteContext) ctx.getEnv().get(TemplateWebsiteServer.TEMPLATE_WEBSITE_FRAMEWORK_KEY);
		if(null == ret)
		{
			throw new RuntimeException("TemplateWebsiteContext not found in context. Do you forget to call super.initRequest when you have overriden in TemplateWebsiteServer?");
		}
		
		return ret;
	}
	
	protected static final SimpleGet<PrettyPrintArrayList> PRETTY_PRINT_LIST = new SimpleGet<PrettyPrintArrayList>()
	{
		@Override
		public PrettyPrintArrayList get()
		{
			return new PrettyPrintArrayList(PrettyPrintArrayList.PRINT_CONTENT_ONLY_UNSEPARATED);
		}
	};
	
	public static void addView(Context ctx, String name, String view)
	{
		Map<String, Object> map = MapTools.ensureSmallMapKey(ctx.getEnv(), "VIEW");
		Object o = map.get(name);
		
		map.put(name, CollectionTools.addOrWrap(o, (SimpleGet) PRETTY_PRINT_LIST, getTemplate(ctx, view)));
	}
	
	public static Template getTemplate(Context ctx, String name)
	{
		return getContextTemplateFw(ctx).WEB_CONTEXT.getView(name);
	}
	
	public static void addViewElement(Context ctx, String name, Object subject)
	{
		Map<String, Object> map = MapTools.ensureSmallMapKey(ctx.getEnv(), "VIEW");
		Object o = map.get(name);
		map.put(name, CollectionTools.addOrWrap(o, (SimpleGet) PRETTY_PRINT_LIST, subject));
	}
	
	public static Collection getViewVarAsCollection(Context ctx, String name)
	{
		Map<String, Object> map = MapTools.ensureSmallMapKey(ctx.getEnv(), "VIEW");
		Object o = map.get(name);
		Collection ret = CollectionTools.addOrWrap(o, (SimpleGet) PRETTY_PRINT_LIST, null);
		map.put(name, ret);
		return ret;
	}
	
	//TODO
	public static void exportTemplatePackage(Collection<ExportTemplate> coll, String templateDir, String _package, String extension)
	{
 		File f = new File(StringTools.toString(templateDir+"/"+_package));
		String[] fs = f.list();
		if(null != fs)
		{
			String ext = "."+extension;
			for(String t:fs)
			{
				coll.add(new ExportTemplate(templateDir, _package+"/"+StringTools.getSubstringBeforeFirstString(t, ext, t), extension));
			}
		}
	}
	
	public static void addViewAndFinish(Context ctx, String name, String view)
	{
		addView(ctx, name, view);
		SiteFacilityTools.finishWithRender(ctx);
	}
	
	//TODO
	public static class ExportTemplate
	{
		protected String rootDir;
		protected String name;
		protected String extension;
		
		public ExportTemplate(String rootDir, String name, String extension)
		{
			this.rootDir = rootDir;
			this.name = name;
			this.extension = extension;
		}
		
		public String getContent() throws IOException
		{
			return IOTools.getFileContents(getFile());
		}
		
		public String getName()
		{
			return name;
		}
		
		public String getFile()
		{
			return rootDir+"/"+name+"."+extension;
		}
		
		public String toString()
		{
			StringBuilder sb = new StringBuilder();
			sb.append("<script type=\"x-tmpl-mustache\" data-template=\""+name+"\">\n");
			try
			{
				sb.append(getContent());
			}
			catch(Exception e)
			{
				sb.append(formatException(e));
			}
			sb.append("</script>");
			return sb.toString();
		}

		public String formatException(Throwable e)
		{
			StringBuilder sb = new StringBuilder();
			sb.append("<pre>");
			sb.append("Can't read template: ");
			sb.append("\n");
			sb.append(Format.getPrintedStackTrace(e));
			sb.append("</pre>");
			return sb.toString();
		}
	}
	
	/**
	 * resourceType: js js_post, css
	 * */
	public static void addResource(Context ctx, String resourceType, String resourceUrl)
	{
		Map<String, Object> map = MapTools.ensureSmallMapKey(ctx.getEnv(), "RESOURCE");
		
		Object[] arr = (Object[]) map.get(resourceType);
		map.put(resourceType, ArrayTools.arrayAppendOrCreate(arr, resourceUrl));
	}
	
	public static void setView(Context ctx, String name, String view)
	{
		TemplateWebsiteContext TWFW = getContextTemplateFw(ctx);
		MapTools.ensureSmallMapKey(ctx.getEnv(), "VIEW").put
		(
			name,
			TWFW.WEB_CONTEXT.getView(view)
		);
	}

	public static GetBy3<? extends Context, SiteFacility, HttpServletRequest, HttpServletResponse> generateContextCreatorWithHooks(final ServiceProcessHooks hooks)
	{
		return new GetBy3<Context, SiteFacility, HttpServletRequest, HttpServletResponse>()
		{
			@Override
			public Context getBy
			(
				SiteFacility a,
				HttpServletRequest b,
				HttpServletResponse c
			)
			{
				RequestContext ctx = new RequestContext(b, c);
				ctx.setServiceProcessHooks(hooks);
				return ctx;
			}
		};
	}
	
	public static interface TemplateWebsiteTemplateDetails
	{
		public TemplateManager createDefaultTemplateManager();
		public void applyView(Context ctx) throws Exception;
		public void initRequest(Context ctx);
		
		
	}
	
	public static TemplateWebsiteServer createTemplateServer
	(
		Dispatcher<Context> dispatcher,
		final SimpleGet<IOStreamServer<IOStream>> serverSocketCreator,
		final TemplateWebsiteDefaultAsset assets,
		final AbstractFile TEMPLATE_ROOT,
		final TemplateWebsiteTemplateDetails templateDetails
	)
	{
		TemplateWebsiteServer srv = null;
		
		try
		{
			srv = new TemplateWebsiteServer(dispatcher)
			{
				@Override
				public TemplateManager createDefaultTemplateManager()
				{
					if(null != templateDetails)
					{
						return templateDetails.createDefaultTemplateManager();
					}
					else
					{
						return new TemplateManager()
						{
							@Override
							public Collection<String> getViews()
							{
								return NullCollection.INSTANCE;
							}
							
							@Override
							public Template getView(String label)
							{
								return null;
							}
						};
					}
				}
				
				@Override
				protected Boolean hook_applyView(Context ctx)
				{
					try
					{
						if(null != templateDetails)
						{
							templateDetails.applyView(ctx);
						}
					}
					catch(Exception e)
					{
						Mirror.propagateAnyway(e);
					}
					return true;
				}
				
				@Override
				public void initRequest(final Context ctx)
				{
					super.initRequest(ctx);
					if(null != templateDetails)
					{
						templateDetails.initRequest(ctx);
					}
				}
				
				@Override
				protected IOStreamServer getWebServerSocket() throws IOException
				{
					//return super.getWebServerSocket();
					return serverSocketCreator.get();//IOStreamFactory.fromServerSocket(new ServerSocket(port));
				}
				
				/*@Override
				public HttpSocketProtocol getHttpProtocol()
				{
					return super.getHttpProtocol();
					//return WellKnownSocketHttpProtocol.FASTCGI;
				}*/
				
				@Override
				protected void hook_exceptionProcess(Context ctx)
				{
					super.hook_exceptionProcess(ctx);
					ctx.getResponse().setStatus(500);
					SiteFacilityTools.finishWithMimeSend(ctx, Format.getPrintedStackTrace((Throwable) ctx.getEnv().get("exception")), MIME.plain);
				}
				
				@Override
				protected void unservedRequest(Context ctx)
				{
					ctx.getResponse().setStatus(404);
					super.unservedRequest(ctx);
				}
			};
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
		}
		
		return srv;
	}
	
	public static final String RESOURCE_DIR = "/home/szupervigyor/projektek/web";
	
	public static void addResourceDisaptcher(DefaultDispatchStructure dds)
	{
		attachResource(dds, "resource", RESOURCE_DIR);
	}
	
	public static void attachResource(DefaultDispatchStructure dds, String rootPath, String f)
	{
		dds.getChains().getChainByName("static").addLink
		(
			WebDispatchTools.createWithPathNodeStart
			(
				new KeyVal<String, AttachDirectoryURLNode>(rootPath, new AttachDirectoryURLNode("", f, true))
			)
		);
	}
}
