package eu.javaexperience.web.dispatch;

public class ThreadLocalDispatchBuilder
{
	protected static final ThreadLocal<DefaultDispatchStructure> builders = new ThreadLocal<>();
	
	public static DefaultDispatchStructure get()
	{
		return builders.get();
	}
	
	public static DefaultDispatchStructure reset()
	{
		DefaultDispatchStructure dds = builders.get();
		builders.set(new DefaultDispatchStructure());
		return dds;
	}
	
	public static void remove()
	{
		builders.remove();
	}
}
