package eu.javaexperience.web.elements;

import java.util.ArrayList;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;

/**
 * Weboldal klóngyár:
 * 	egy megadott elemet lehet vele klónoztatni, viszont a HtmlPart(String) osztállyal megjelölt elemeket
 *  egy listába gyűjti ki, közvetlen hozzáférést biztosítva az egyes tagokhoz. A HtmlPart(String) tag első
 *  leszármazottja kerül csak klónozásra. A megadott jeleket identikusan kell kezelni ugyanazt a
 *  Stringet kell visszaadni hivakozáskor ClonedPage Objektumnak.
 *  Az átadott HElementet átadás után nem szabad módasítani.
 *  Ha ez nem teljesíthető akkor használd a HElement.deepClone() metódusát és azt add át!
 * */
public class ClonePageFactory
{
	protected ArrayList<String> jels = new ArrayList<>();
	protected HElement root;
	protected ArrayList<KeyVal<String, HElement>> parts = new ArrayList<>();
	
	
	public ClonePageFactory(HElement root)
	{
		if(root == null)
			throw new IllegalArgumentException("A gyökér elem nem lehet null!");

		jelIterator(root);
		this.root = root;
	}
	
	/**
	 * Visszaadja a gyökér elemet, ebből az elemből képződnek a klónok így azok is megváltoznak
	 * (az újonnan létrehozottak)
	 * */
	@Deprecated
	public HElement getDirectRoot()
	{
		return root;
	}

	/**
	 * Visszaadja a sablonban lévő szekció referenciáját, ebből képződnek a klónok is, ennek módosítása
	 * a klónok megváltoztatását is eredményezi (az újnonnan létrehozottakét)
	 * */
	@Deprecated
	public @MayNull HElement getDirectSubSection(String part)
	{
		for(KeyVal<String, HElement> kv: parts)
			if(kv.getKey().equals(part))
				return kv.getValue();

		return null;
	}
	
	protected void jelIterator(HElement e)
	{
		if(e.isJelolo())
		{
			jels.add(e.getText());
			parts.add(new KeyVal<String, HElement>(e.getText(), e.getDirectSubelements().get(0)));
		}
		
		for(HElement el:e)
			if(el != null)
				jelIterator(el);
	}

	public ClonedPage clone()
	{
		ClonedPage ret = new ClonedPage();

		ArrayList<KeyVal<String,HElement>> lista = new ArrayList<>();
		ret.root = internalDeepClone(root, lista);
		ret.jelToElem = lista;

		return ret;
	}

	/**
	 * Klónozza a megadott elemet és a listába kigyüjti a rész nevét és a rá mutató referenciát.
	 * ha a lista null akkor nem gyüjti csak klónozza.
	 * */
	protected HElement internalDeepClone(HElement elem,ArrayList<KeyVal<String,HElement>> lista)
	{
		HElement ret = elem.topLvlClone();		

		HElement buf = null;
		for(HElement e:elem)
			if(e != null)
				if(lista != null && e.isJelolo())
				{
					if((buf = regAndInternalDeepCloneElement(e, lista)) != null)
						ret.addHElements(buf);
				}
				else
					ret.addHElements(internalDeepClone(e, lista));
		
		return ret;
	}

	protected HElement regAndInternalDeepCloneElement(HElement elem,ArrayList<KeyVal<String,HElement>> lista)
	{
		HElement e = elem.moreElements.size()>0?(e=elem.moreElements.get(0)):null;
		if(e == null)
			return null;

		e =  internalDeepClone(e, lista);

		lista.add(new KeyVal<String, HElement>(elem.getText(), e));
		return e;
	}
	
	/**
	 * Közvetlenül klónozza a megadott element.
	 * a section paraméter nem kell hogy identikus legyen
	 * null esetén a root-ot klónozza.
	 * ha a megadott rész nem létezik akkor null-t ad vissza 
	 * */
	public @MayNull HElement directCloneSubSection(@MayNull String section)
	{
		if(section == null)
			return internalDeepClone(root, null);

		for(KeyVal<String, HElement> e:parts)
			if(section.equals(e.getKey()))
				return internalDeepClone(e.getValue(), null);
		
		return null;
	}

	/**
	 * Az eljárás ugyanaz mint directCloneSubSection esetén de ha a rész nem 
	 * található akkor a gyökér elem másolatával tér vissza.
	 * Null biztos eljárás
	 * */
	public @MayNotNull HElement directCloneSubSectionOrFullDocument(@MayNull String section)
	{
		HElement ret = directCloneSubSection(section);
		if(ret == null)
			return directCloneSubSection(null);
		return ret;
	}
	
	public String getIdenetityByString(String str)
	{
		for(String s:jels)
			if(str.equals(s))
				return s;

		return null;
	}

	public String[] getIdenetitySzekcio()
	{
		return jels.toArray(Mirror.emptyStringArray);
	}

	public String toString()
	{
		return "ClonePageFactory: "+root;
	}
	
}