package eu.javaexperience.web.elements;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import java.util.regex.Pattern;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.io.ToAppendable;

/**
 * Nem szinkronizált osztály, a szinkronizációt külsőleg kell megoldani
 * 
 * 
 * ~2014: TODO hogyan lehetne ezt újrahasznosítani? az egész fát allandóan lemásolni nagy művelet...
 * adni kellene egy példányt amit "alaphelyzetbe" lehetne állítani a legkevesebb művelettel és azt módosítani
 * 
 * 2016: Ott a {@link RazorTransformer} ami a fát csak a kiiratáshoz hasznájla.
 * A fán megy végig a kiiratás és a {@link HElementRenderModifier} add hozzá plusz dolgokat
 * illetve ismétli/szelektálja/stb. az elemek renderelésést.
 * */
public class HElement implements Iterable<HElement>, Serializable, ToAppendable
{
	/**
	 *
	 */
	private static final long serialVersionUID = -9119947808135670134L;

	
	public final String tagName;
	protected List<HElement> moreElements = new ArrayList<>();
	protected String text;
	protected SmallMap<String,String> attributes = new SmallMap<>();
	protected HElementRenderModifier modder;

	
	public static final HElement[] emptyhearr = new HElement[0];

	public static interface PrototypeTag
	{
		public String getTagName();
	}
	
	public static class SimpleTag implements PrototypeTag
	{
		private final String name;
		
		public SimpleTag(String name)
		{
			//tesztelésre
			this.name = new HElement(name).tagName;
		}

		@Override
		public String getTagName()
		{
			return name;
		}
	}
	
	public boolean isJelolo()
	{
		return false;
	}

	protected HElement(String tagName,Object IGNORED)
	{
		this.tagName = tagName;
	}

	public HElement(PrototypeTag tag)
	{
		if(tag == null)
			throw new IllegalArgumentException("A TAG enum nem lehet null");

		tagName = tag.getTagName();
	}

	public HElement(String tagNev)//nem megbízható konstruktor, több ellenőrzéssel
	{
		if(tagNev == null)
			throw new IllegalArgumentException("A TAG neve nem lehet null");

		tagNev = tagNev.toLowerCase();

		if(!Pattern.matches("!?[a-z]+[a-z0-9]*", tagNev))
			throw new IllegalArgumentException(tagNev+" érvénytelen tag név");

		tagName = tagNev;
	}

	public boolean hasAttribute(String attr)
	{
		if(attr == null)
			return false;

		return attributes.get(attr) != null;
	}

	public String getAttribute(String attr)
	{
		return attributes.get(attr);
	}

	/**
	 * Láncépíthető
	 */
	public HElement addAttribute(String key,String value)
	{
		if(key != null)
			attributes.put(key, value);
		return this;
	}
	
	public HElement addNotNullValueAttribute(String key,String value)
	{
		if(key != null && null != value)
		{
			attributes.put(key, value);
		}
		return this;
	}
	
	public HElement glueToAttribute(String key, String glue, String value)
	{
		if(key != null && null != value)
		{
			String in = attributes.get(key);
			if(null == in)
			{
				attributes.put(key, value);
			}
			else
			{
				attributes.put(key, in+glue+value);
			}
		}
		return this;
	}
	
	
	/**
	 * Láncépíthető
	 */
	public HElement delAttribute(String key)
	{
		attributes.remove(key);
		return this;
	}

	/**
	 * Láncépíthető
	 */
	public HElement appendAttributeString(String key,String appendVal)
	{
		if(appendVal == null || key == null)
			return this;

			String val = attributes.get(key);
			if(val == null)
			{
				attributes.put(key, appendVal);
				return this;
			}

			val+= appendVal;
			attributes.put(key, appendVal);

			return this;
	}

	/**
	 * Láncépíthető
	 */
	public HElement appendAttributeStrings(String key,String... appendVal)
	{
		if(appendVal == null)
			return this;

		if(appendVal.length == 0)
			return this;

		if(appendVal.length == 1)
		{
			appendAttributeString(key, appendVal[0]);
			return this;
		}

		StringBuilder sb = new StringBuilder();
		String inital = attributes.get(key);
		if(key != null)
			sb.append(inital);
		for(int i = 0;i< appendVal.length;i++)
			if(appendVal[i] != null)
				sb.append(appendVal[i]);

			attributes.put(key, sb.toString());

		return this;
	}

	public HElement unsetChild(int i)
	{
		moreElements.remove(i);
		return this;
	}
	
	/**
	 * Láncépíthető
	 */
	public HElement appendAttributeStringsSeparatedBy(String key,String sepatator,String... appendVal)
	{
		if(appendVal == null)
			return this;

		if(appendVal.length == 0)
			return this;

		if(appendVal.length == 1)
		{
			appendAttributeStrings(key,sepatator, appendVal[0]);
			return this;
		}

		StringBuilder sb = new StringBuilder();
		String inital = attributes.get(key);
		if(key != null)
		{
			sb.append(inital);
			sb.append(sepatator);
		}

		for(int i = 0;i< appendVal.length;i++)
		{
			if(appendVal[i]== null)
				continue;

			sb.append(appendVal[i]);
			if(i != appendVal.length-1)
				sb.append(sepatator);
		}

		attributes.put(key, sb.toString());

		return this;
	}

	public Iterable<Entry<String,String>> getAttrs()
	{
		return attributes.entrySet();
	}
	
	/**
	 * Láncépíthető
	 */
/*	@Deprecated
	public HElement addClasses(String... cls)
	{
		for(int i=0;i< cls.length;i++)
			if(cls[i] != null)
				if(!classes.contains(cls[i]))
					classes.add(cls[i]);

		return this;
	}

	@Deprecated
	public HElement removeClasses(String... cls)
	{
		if(cls!=null)
			for(String c:cls)
				if(c != null)
					classes.remove(c);

		return this;
	}

	public boolean hasClasses(String... cls)
	{
		if(cls == null)
			return false;

		for(String cl:cls)
			if(cl != null)
				if(!classes.contains(cl))
					return false;

		return true;
	}

	@Deprecated
	public boolean hasOnlyClasses(String... cls)
	{
		if(classes.size() != cls.length)
			return false;

		for(String cl:cls)
			if(!classes.contains(cl))
				return false;

		return true;
	}

	@Deprecated
	public HElement setClasses(String... cls)
	{
		classes.clear();

		for(String s:cls)
			if(!classes.contains(s))
				classes.add(s);

		return this;
	}

	public HElement yourByOnlyClasses(String... cls)
	{
		if(hasOnlyClasses(cls))
			return this;

		if(moreElements == null)
			return null;

		ArrayList<HElement> antiLoop = new ArrayList<HElement>();

		return antiLoopYourByOnlyClasses(cls, antiLoop);
	}

	public HElement yourByClass(String cls)
	{
		if(hasClasses(cls))
			return this;

		if(moreElements == null)
			return null;

		ArrayList<HElement> antiLoop = new ArrayList<HElement>();

		return antiLoopYourByClass(cls, antiLoop);
	}

	protected HElement antiLoopYourByClass(String cls,ArrayList<HElement> elemek)
	{
		if(hasClasses(cls))
			return this;

		if(moreElements == null)
			return null;
		for(int i=0;i<moreElements.size();i++)
			if(moreElements.get(i) != null)
				if(!elemek.contains(moreElements.get(i)))
				{
					elemek.add(moreElements.get(i));
					HElement el = moreElements.get(i).antiLoopYourByClass(cls, elemek);
					if(el != null)
						return el;
				}
		return null;
	}

	/**
	 * magán örökölhető metódus, ami feltétlezei hogy a yourByOnlyClass hívta meg
	 * */
/*	protected HElement antiLoopYourByOnlyClasses(String[] cls,ArrayList<HElement> elemek)
	{
		if(hasOnlyClasses(cls))
			return this;

		for(int i=0;i<moreElements.size();i++)
			if(moreElements.get(i) != null)
				if(!elemek.contains(moreElements.get(i)))
				{
					elemek.add(moreElements.get(i));
					HElement el = moreElements.get(i).antiLoopYourByOnlyClasses(cls, elemek);
					if(el != null)
						return el;
				}
		return null;
	}
*/	
	public HElement setRenderModifier(HElementRenderModifier modder)
	{
		this.modder = modder;
		return this;
	}
	
	public HElementRenderModifier getRenderModifier(HElementRenderModifier modder)
	{
		return modder;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		try
		{
			append(sb);	
		}
		catch(IOException e) //A StringBuilder nem dob ilyet
		{}
		
		return sb.toString();
	}

/*	protected void chainToString(StringBuilder sb,ArrayList<HElement> blacklist)
	{
		if(tagTipus != TagTipus.elemi)
			if(blacklist.contains(this))
			{
				sb.append("<UnexceptedLoop>");
				return;
			}

		putMyTagStart(sb);

		if(tagTipus == TagTipus.befogado)
		{
			if(text != null)
				sb.append(text);

			blacklist.add(this);
			for(HElement e:moreElements)
				e.chainToString(sb, blacklist);
		}
		putMyTagEnd(sb);
	}

	public void append(Appendable app) throws IOException
	{
		switch(tagTipus)
		{
		case befogado:
		{
			ArrayList<HElement> bl = new ArrayList<HElement>();
			chainAppend(app, bl);
			return;
		}

		case attributumos:
		{
			appendMyTagStart(app);
			return;
		}

		case elemi:
			app.append("<");
			app.append(tagName);
			app.append("/>");
			return;

		default:
			throw new IllegalStateException("A Tagnak határozatlan a típusa");
		}
	}
*/
	
	public boolean hasCloseTag()
	{
		if(tagName == null)
			return false;
		return tagName.charAt(0) != '!';
	}
	
	protected static String lvl = "\t";
	protected static String eol = "\n";
	
	public void append(Appendable app) throws IOException
	{
		append(app,"",lvl,eol);
	}
	
	public void append(Appendable app, String crnt, String lvl1, String EOL) throws IOException
	{
		if(modder != null)
			if(!modder.beforeStartTagAppend(this, app, crnt, lvl1, EOL))
				return;
		
		if(crnt != null)
			app.append(crnt);
		
		if(tagName != null)
		{
			app.append('<');
			app.append(tagName);
	
			if(attributes.size() > 0)
			{
				Iterator<String> it = attributes.getKeyIterator().iterator();
				String key = null;
				while(it.hasNext())
				{
					key = it.next();
					app.append(' ');
					app.append(key);
					String val = attributes.get(key);
					if(val != null)
					{
						app.append("=\"");
						app.append(val);
						app.append('"');
					}
				}
			}
		}
		
		boolean hasCloseTag = hasCloseTag();
		boolean notJustText = moreElements.size() > 0 && crnt != null;
		
		if(moreElements.size() == 0 && hasCloseTag && text == null)
		{
			app.append("/>");
			if(crnt != null)
				app.append(EOL);
			return;
		}
		else if(tagName != null)
			app.append(">");
		
		if(notJustText)
		{
			app.append(EOL);
		//	app.append(crnt);
		}
		
		if(modder != null)
			modder.beforeTextAppend(this, app);
		
		
		if(text != null)
			app.append(text);
		
		if(modder != null)
			modder.beforeSubelementsAppend(this, app);
		
		if(crnt == null)
		{
			for(HElement e:moreElements)
				e.append(app);
		}
		else
		{
			String nxt = crnt==null?null:crnt+lvl1; 
			for(HElement e:moreElements)
			{
				e.append(app,nxt,lvl1,EOL);
			}
		}
		
		if(modder != null)
			modder.beforeEndTagAppend(this, app);
		
		if(hasCloseTag)
		{
			if(notJustText)
			{
				app.append(crnt);
			}
			
			app.append("</");
			app.append(tagName);
			app.append(">");
		}
		
		if(crnt != null)
			app.append(EOL);
		
		if(modder != null)
			modder.afterCloseTagAppend(this, app);
	}

	/**
	 * Láncépíthető
	 */
	public HElement addHElements(HElement... elems)
	{
		if(elems == null)
			return this;

		for(int i=0;i<elems.length;i++)
			if(elems[i] != null)
				moreElements.add(elems[i]);

		return this;
	}
	
	public HElement addHElements(Collection<HElement> elems)
	{
		if(elems == null)
			return this;

		for(HElement e:elems)
			if(e != null)
				moreElements.add(e);

		return this;
	}

	/**
	 * Láncépíthető
	 */
	public HElement addHElements(HElement elems)
	{
		if(elems != null)
			moreElements.add(elems);

		return this;
	}
	
	public int sizeSubElements()
	{
		return moreElements.size();
	}

	public HElement[] getAllSubElements()
	{
		if(moreElements == null)
			return new HElement[]{this};

		ArrayList<HElement> elemz = new ArrayList<HElement>();
		getAllSubElements(elemz);
		return elemz.toArray(emptyhearr);
	}

	protected void getAllSubElements(ArrayList<HElement> elemz)
	{
		elemz.add(this);
		if(moreElements == null)
			return;

		for(HElement e:moreElements)
			if(!elemz.contains(e))
				e.getAllSubElements(elemz);
	}

	public boolean hasHElements(HElement... elems)
	{
		if(moreElements == null||elems == null)
			return false;

		for(int i=0;i<elems.length;i++)
			if(elems[i]!=null)
				if(!moreElements.contains(elems[i]))
					return false;

		return true;
	}

	/**
	 * Láncépíthető
	 */
	public HElement delHElements(HElement... elems)
	{
		if(moreElements == null || elems == null)
			return this;

		for(int i=0;i<elems.length;i++)
			if(elems[i] != null)
				if(!moreElements.contains(elems[i]))
					moreElements.add(elems[i]);

		return this;
	}

	/**
	 * Láncépíthető
	 */
	public HElement setHElements(HElement... elems)
	{
		if(moreElements == null || elems == null)
			return this;

		moreElements.clear();
		return addHElements(elems);
	}

	public HElement unsetChilds()
	{
		moreElements.clear();
		return this;
	}
	
	/**
	 * Láncépíthető
	 */
	public HElement setText(String str)
	{
		text = str;
		return this;
	}

	public HElement appendText(String... strs)
	{
		if(strs == null)
			return this;

		StringBuilder sb = new StringBuilder();

		if(text != null)
			sb.append(text);

		for(int i=0;i< strs.length;i++)
			if(strs[i] != null)
				sb.append(strs[i]);

		text = sb.toString();
		return this;
	}

	public String getText()
	{
		return text;
	}
	
	/**
	 * Visszaadja ennek az elemnek a pontos klónját az al-elemek klónozása nélkül. 
	 * ezt tipikusan a {@link ClonePageFactory} használja. Ha valami új funkció kerül 
	 * ehhez az osztályhoz és a klónozott elemben is meg kell ennek jelennie akkor
	 * itt kell azt megvalósítani.
	 * 
	 * Pl.: az attributumokat lustábban kellene kezelni és kezdetben null-nak hagyni.
	 * Most itt null pointerrel elszállna. Ha a lusta inicializáció be lesz vezetve
	 * akkor itt ebben az egységben kell ezt módosítani és nem kell körbejárni azokat
	 * az osztályokat amelyek arra számítanak hogy ez sose null. (Bár ehhez csak
	 * csomagon belül férnek hozzá)
	 * */
	public HElement topLvlClone()
	{
		HElement ret = new HElement(tagName,null);
		ret.text = text;
		ret.attributes = attributes.clone();
		ret.modder = modder;
		
		return ret;
	}

	public HElement deepClone()
	{
		HElement ret = new HElement(tagName,null);

		ret.text = text;

		if(attributes != null)
		{
			ret.attributes = new SmallMap<>();

			if(attributes.size()>0)
				for(Entry<String,String> ss:attributes.entrySet())
					ret.attributes.put(ss.getKey(), ss.getValue());
		}

/*		if(classes != null)
			if(classes.size() == 0)
				ret.classes = new ArrayList<>();
			else
				for(String c :classes)
					ret.addClasses(c);*/

		if(moreElements != null)
			for(HElement e:moreElements)
				ret.addHElements(e.deepClone());

		return ret;
	}

	public HElement directCloneAs(String tagName)
	{
		HElement ret = new HElement(tagName,null);

		ret.text = text;

		if(attributes != null)
			ret.attributes = attributes.clone();

/*		if(classes != null)
		{
			String[] cls = classes.toArray(emptysa);
			ret.classes = new ArrayList<String>();
			for(String c :cls)
				ret.addClasses(c);
		}
*/
		if(moreElements != null)
			ret.addHElements(moreElements.toArray(emptyhearr));

		return ret;
	}

	public boolean hasMoreHElements()
	{
		if(moreElements != null)
			return moreElements.size() >0;

		return false;
	}

	/************************************* És most jönnek a mágiák  *******************************/

	public static enum SliderSelectType
	{
		value,
		range
	}

	public static enum SliderOrientation
	{
		horizontal,
		vertical
	}

	public HElement slider(int min,int max,SliderSelectType seltype,SliderOrientation oritype,int start1,int start2)//vetrikáis vagy horizontális, range vagy val, min,max
	{
		if(seltype == null)
			throw new IllegalArgumentException("A kiválasztás típusa nem lehet null!");

		if(oritype == null)
			throw new IllegalArgumentException("A elrendezés típusa nem lehet null!");

		addAttribute("class","EXEC");
		addAttribute("data-exec","{'action':'regSlider','min':"+min+",'max':"+max+",'ori':"+oritype.ordinal()+",'sel':"+seltype.ordinal()+",'s1':"+start1+",'s2':"+start2+"}");
		return this;
	}

	/**
	 * közvetlenül visszaadja azt a tömblistát amelyben az alelemei vannak.
	 * itt meg lehet kerülni az addHelements(HElement...) null tesztjét, ha ki kellene akasztani.
	 * */
	public List<HElement> getDirectSubelements()
	{
		return moreElements;
	}

	public HElement draggable()
	{
		addAttribute("class","LFDA");
		return this;
	}

	public HElement droppable()
	{
		addAttribute("class","LFDO");
		return this;
	}

	public HElement sortable()
	{
		addAttribute("class","SORT");
		return this;
	}

	private static final Iterator<HElement> nullIterator = new Iterator<HElement>()
	{
		@Override
		public boolean hasNext()
		{
			return false;
		}

		@Override
		public HElement next()
		{
			return null;
		}

		@Override
		public void remove()
		{}
	};

	@Override
	public Iterator<HElement> iterator()
	{
		if(moreElements == null)
			return nullIterator;

		return new Iterator<HElement>()
		{
			int it = 0;
			@Override
			public boolean hasNext()
			{
				return it < moreElements.size();
			}

			@Override
			public HElement next()
			{
				return moreElements.get(it++);
			}

			@Override
			public void remove()
			{
				moreElements.remove(it-1);
			}
		};
	}
	
	public HElement getElementById(String id)
	{
		return HElementTools.findElementById(this, id);
	}

	public void addFirstChild(HElement e)
	{
		if(null != e)
		{
			moreElements.add(0, e);
		}
	}

	public void applyOnTree(SimplePublish1<HElement> modifier)
	{
		modifier.publish(this);
		for(HElement c:moreElements)
		{
			c.applyOnTree(modifier);
		}
	}
	
/*	protected static final SimplePublish3<String, String, DataObject> PUT_ATTRIBUTES = new SimplePublish3<String, String, DataObject>()
	{
		@Override
		public void publish(String a, String b, DataObject c)
		{
			c.putString(a, b);
		}
	};
	
	public DataObject toObject(DataCommon common)
	{
		DataObject obj = common.newObjectInstance();
		obj.putString("name", tagName);
		if(attributes.size() > 0)
		{
			DataObject attr = common.newObjectInstance(); 
			attributes.each(PUT_ATTRIBUTES, attr);
			obj.putObject("attr", attr);
		}
		
		if(moreElements.size() > 0)
		{
			DataArray arr = common.newArrayInstance();
			for(HElement h:moreElements)
			{
				arr.putObject(h.toObject(common));
			}
			obj.putArray("child", arr);
		}
		
		return obj;
	}
*/
}