package eu.javaexperience.web.elements;

import eu.javaexperience.asserts.AssertArgument;

public class HtmlPart extends HElement
{
	private static final long serialVersionUID = 1L;

	public static final String htmlPartString = "HtmlPart";
	
	public HtmlPart(String name)
	{
		super(htmlPartString);
		AssertArgument.assertNotNull(name, "Name of part");
		setText(name);
	}

	public static HElement newInstance(String szekcionev)
	{
		return new HtmlPart(szekcionev);
	}

	public boolean isJelolo()
	{
		return true;
	}
}