package eu.javaexperience.web.elements;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import eu.javaexperience.document.DocumentTools;

public class SaxHElementParser
{
	public static HElement parseHtmlSax(String html) throws SAXException, IOException, ParserConfigurationException
	{
		return parseHtmlSax(new ByteArrayInputStream(html.getBytes()));
	}
	
	public static HElement parseHtmlSax(InputStream is) throws SAXException, IOException, ParserConfigurationException
	{
		Document doc = DocumentTools.parseDocument(is);
		Element e = doc.getDocumentElement();
		return processNode(e);
	}
	
	private static HElement processNode(Node n)
	{
		HElement ret = createHElementFromNode(n);
		if(ret == null)
			return null;
		
		String sect = ret.getAttribute("section");
		convertSubNodes(n, ret);
		if(sect != null)
			ret.delAttribute("section");

		return sect == null?ret:new HtmlPart(sect).addHElements(ret);
	}
	
	private static void convertSubNodes(Node node,HElement elem)
	{
		NodeList nodes = node.getChildNodes();//node.childNodes();
		
		if(nodes.getLength() == 0)
		{
			String name = node.getNodeName();
			if(!isSelfCloseTag(name) && elem.getText() == null)
				elem.setText("");
			return;
		}
		
		int start = 0;
	//	boolean otxt = true;
		
		if(nodes.getLength() > 0)
		fi:{
			Node no = nodes.item(0);
			String nona = no.getNodeName();
			if("#comment".equals(nona)) //kommenteket nem jelenítünk meg, kihagyjuk
			{
				start = 1;
				break fi;
			}

			if(!("#text".equals(nona)  || "#data".equals(nona)))// ha nem szöveg akkor mehet a normál módon
				break fi;

			//ha csak egy szöveg van akkor állítsunk be szöveget, akkor is ha a tag nem "önzáró"
			
			String nos = no.getTextContent().trim();//"#data".equals(nona)?no.attr("data"):no.outerHtml().trim();
			boolean notSelfClose = !isSelfCloseTag(nona);

			if(nos.length() == 0)
			{
				if(notSelfClose)//nem önzáró így egy üres szöveg megy.
					nos = "";
				else // nem állítunk be szöveget, üres blokk eltávolítása, mehet a 1 indextől a feldolgozás
				{
					start = 1;
					break fi;
				}
			}
			
			start = 1;
			elem.setText(nos);
		}
		
		for(int i=start;i < nodes.getLength();i++)// ha az első értelmes szöveg, akkor az az ide tartozó text
		{
			Node n = nodes.item(i); 
			/*HElement crtn = createHElementFromNode(n);
			if(crtn == null)
				continue;
			convertSubNodes(n, crtn);
			elem.addHElements(crtn);*/
			elem.addHElements(processNode(n));
		}
	}
	
	private static HElement createHElementFromNode(Node node)
	{
		String name = node.getNodeName();
		
		if("#comment".equals(name))
			return null;
		
		if("#text".equals(name))
		{
			String oh = node.getTextContent().trim();
			
			if(oh.length() == 0)
				return null;
			
			return Tag.invisibleGroup.newInstance().setText(oh);
			//return Tag.span.newInstance().setText(oh);
		}
		
		if("!data".equals(name))
		{
			String oh = node.getTextContent();
			if(oh.length() == 0)
				return null;
			
			return Tag.invisibleGroup.newInstance().setText(oh);
		}
		
		if("#doctype".equals(name))
		{
			HElement ret = Tag.doctypeHtml.newInstance();//new HElement("!doctype");
			/*NamedNodeMap attrz = node.getAttributes();
			for(int i=0;i<attrz.getLength();i++)
			//for(Attribute a:attr)
				if("name".equals(attrz.item(i).getNodeName()))
					ret.addAttribute(attrz.item(i).getTextContent(), null);*/
			
			return ret;
		}
		
		HElement ret = new HElement(node.getNodeName());//.replace('#', '!')
		NamedNodeMap attrz = node.getAttributes();
		for(int i=0;i<attrz.getLength();i++)
			ret.addAttribute(attrz.item(i).getNodeName(), attrz.item(i).getTextContent());
		//List<Attribute> attr = node.attributes().asList();
		//for(Attribute a:attr)
			//ret.addAttribute(a.getKey(), a.getValue());

		return ret;
	}

	private static final String[] selfClosTags = new String[]{"br","img","meta","link","input","base"};
	
	public static boolean isSelfCloseTag(String self)
	{
		for(String s:selfClosTags)
			if(s.equals(self))
				return true;
		
		return false;
	}
	
}