package eu.javaexperience.web.elements;


import java.util.HashMap;
import java.util.Map;

import eu.javaexperience.web.elements.HElement.PrototypeTag;

public enum Tag implements PrototypeTag
{
	doctypeHtml("HTML dokumentum kötelező"),
	a("link, befogadó, href attr ahova a hivatkozás mutat"),
	abbr("Címek megjelölése, befogadó, title attr a szöveg magadásához"),
	acronym("Betűszavak jelentése, befogadó, title attr hogy mit jelent"),
	address("elérhetőségek,befogadó"),
	applet("Beágyazott alkamazás"),
	area("map-hez használt kép területre osztásának akció hozzárengelése, shape attr forma[rect,poly], coords attr koordináták"),
	article("Cikk"),
	aside("idézet kihúzása másik oldalra"),
	audio("hang tartalon, src attr url"),
	b("félkövér betű"),
	base("weboldal gyökere, href attr az URL"),
	bdi("irási iránynak megfelelő szöveg kiiratás"),
	bdo("szövegirány, dir attr[ltr,rtl]"),
	blockquote("Idézet blokk"),
	body("dokumetum hasznos elemei"),
	br("új sor"),
	button("Formázott gomb, type attr[submit,reset,button]"),
	canvas("rajzolható vászon"),
	caption("Táblázat felirat"),
	cite("idézet, title attr szöveg"),
	code("forráskód befogasdó tag"),
	col("táblázat celláinak beállítása colgroup tag-ben"),
	colgroup("táblázat cellacsoportjainak beállítása"),
	data("gépek számára, value attr"),
	datagrid("adatstruktúra ol > li akárhányszor egymásba"),
	datalist("autocomplete adat lista"),
	dd("definició leírás dl > dt tag-ben"),
	del("törölt szöveg jelzése"),
	details("elrejthető, mutatható részletek, még nem támogatott"),
	dfn("szöveges definició kezdete"),
	dir("\"mappa listázása\" tag li az elemek tartója"),
	div("dokumentum szekció"),
	dl("definíció lista kezdése"),
	dt("definíciós lista elem"),
	em("hangasúlyos szöveg elem"),
	embed("beágyazott elem, src attr url, type attr mime tipus"),
//	eventsource("szerveroldali esemény"),
	fieldset("mezők halmaza, legend tag címke"),
//	figurecaption(""),
//	figure(""),
	footer("lábléc"),
	form("űrlap, attr method[post,get] action attr url"),
	h1("h1 bekezdés"),
	h2("h2 bekezdés"),
	h3("h3 bekezdés"),
	h4("h4 bekezdés"),
	h5("h5 bekezdés"),
	h6("h6 bekezdés"),
	head("fejléc tag"),
//	header(""),
//	hgroup(""),
	hr("horizontális vonal"),
	html("HTML dokumentum befogadó tag"),
	iframe("Beágyazott frame"),
	img("kép tag, src attr kép url, alt attr szöveg, usemap attr map megjelölése"),
	input("input type attr[text,password,checkbox,radio,submit,reset,file,hidden,image,button]"),
	ins("törölt helyett <del> beillesztett szöveg"),
	kbd("\"Felhasználó által bevitt szöveg\""),
//	keygen(""),
	label("inputnál cimke, rádiógomb vagy jelölődoboz kattintásához"),
	legend("fieldset jelölőelem"),
	li("listaelem"),
	link("dokumetum belinkelése, src attr url,type attr mime tipus"),
	mark("megjelölés szövegben"),
	map("képhez használt térkép"),
	menu("menü, li elemeket tartalmaz"),
	meta("komplex http://www.quackit.com/html_5/tags/html_meta_tag.cfm"),
	meter("mérő! mint,max value attr ,ill title aattr"),
	nav("navigációs blokk"),
	noscript("látható a tag ha a javascript nem támogatott"),
	object("beágyazott objektum ,mint az applet, param tagokat tartlamazhat"),
	ol("rendezett lista, start attr számozás indítása, type=[1aAiI] ,ill attr egyedül: reverse"),
	optgroup("select-ben választható csoportok"),
	option("select-ben opció"),
	output("kimenetnek fenntartott hely"),
	p("bekezdés"),
	param("object-ben egy paraméter name=\"...\", value=\"...\""),
	pre("előformázott szöveg"),
	progress("progress bar attr max,value"),
	q("idézet idézőjelekkel"),
	s("nem aktuális szöveg"),
	samp("stdout betüstílus"),
	script("script befogadó, type attr mime tipus"),
	section("részlegelválasztó"),
	select("ComboBox tag"),
	small("kisbetűs szöveg"),
	source("multimédi forrás, type attr mime tipus"),
	span("az inline div"),
	strong("lényeges szöveg, nem csak félkövér"),
	style("stílusleíró tag"),
	sub("szöveg mint alsóindex"),
//	summary(""),
	sup("szöveg mint felső index"),
	table("táblázat"),
	tbody("táblázat teste"),
	td("tabálzat cellája"),
	textarea("szövegmező, rows sorok cols oszlopok"),
	tfoot("táblázat láblece"),
	th("táblafejléc cella"),
	thead("tábla fejléc"),
	time("html időbélyeg, datetime attr-ben megadva"),
	title("címmező szöveg a head tag között"),
	tr("táblázat sora"),
	track("következő tartalom audio és video tag-ek között"),
	u("aláhúzott szöveg"),
	ul("Rendezetlen lista"),
	var("szöveg mint változó"),
	video("videós tartalom"),
	wbr("szótaghatár megjelölő, ahol a böngésző itt tördelheti a szöveget"),
	invisibleGroup("Láthatatlan csoportosító")
	{
		public String getTagName()
		{
			return null;
		}
	},
	
/*	panel("Panelkezelő")
	{
		public HElement newInstance()
		{
			return panelSkel.deepClone();
		}
	}*/

	;
	public final String leiras;

	private Tag(String leiras)
	{
		this.leiras = leiras;
	}

	private static Map<String,Tag> tagByString = new HashMap<String,Tag>();

	public static Tag getTagByString(String str)
	{
		return tagByString.get(str);
	}

	public String getTagName()
	{
		return name();
	}
	
	static
	{
		Tag[] tags = Tag.values();
		for(Tag t: tags)
		{
			tagByString.put(t.name(), t);
		}
	}

	public HElement newInstance()
	{
		return new HElement(this);
	}
}