package eu.javaexperience.web.elements;

import eu.javaexperience.semantic.references.MayNull;

public class TwitterBootstrapTools
{
	public static HElement BS_content(HElement elem)
	{
		return Tag.div.newInstance().addAttribute("class", "content");
	}
	
	public static HElement div(HElement... in)
	{
		return Tag.div.newInstance().addHElements(in);
	}
	
	public static HElement BS_row_always_12(HElement content)
	{
		HElement ret = Tag.div.newInstance();
		ret.addHElements(content);
		ret.addAttribute("class", "col-md-12 col-xs-12");
		return ret;
	}
	
	public static HElement textCenterBox(HElement elem)
	{
		return Tag.div.newInstance().addAttribute("class", "text-center").addHElements(elem);
	}
	
	public static HElement BS_desktop_6_6__tablet_12_12(HElement c1, HElement c2)
	{
		return Tag.div.newInstance().addAttribute("class", "row").addHElements
		(
			Tag.div.newInstance().addAttribute("class", "col-md-6").addHElements(c1),
			Tag.div.newInstance().addAttribute("class", "col-md-6").addHElements(c2)
		);
	}
	
	public static HElement BS_linkButton(String label, String href)
	{
		return Tag.a.newInstance()
				.addAttribute("class", "btn btn-primary")
				.setText(label)
				.addAttribute("href", href);
	}
	
	public static HElement BS_button(String label, @MayNull String id, @MayNull String classes)
	{
		HElement ret = Tag.button.newInstance()
				.addAttribute("class", "btn btn-primary "+(null == classes? "":classes))
				.setText(label);
		
		if(null != id)
		{
			ret.addAttribute("id", id);
		}
		
		return ret;
	}

	public static HElement fancyTable()
	{
		return Tag.table.newInstance().addAttribute("class", "table table-striped table-hover");
	}
}
