package eu.javaexperience.web.elements.form;

import java.util.Collection;
import java.util.Map.Entry;

import eu.javaexperience.web.elements.HElement;
import eu.javaexperience.web.elements.Tag;

public class BootstrapFormRenderer
{
	public static <T> HElement render(SimplifiedFormModel<T> form, T ctx)
	{
		HElement ret = Tag.form.newInstance();
		ret.addNotNullValueAttribute("method", form.getMethod(ctx).name());
		ret.addNotNullValueAttribute("action", form.getAction(ctx));
		ret.addNotNullValueAttribute("id", form.getId(ctx));
		ret.addNotNullValueAttribute("class", form.getClasses(ctx));
		
		Collection<Entry<String, String>> dataset = form.getDataset(ctx);
		if(null != dataset)
		{
			for(Entry<String, String> data:dataset)
			{
				if(null != data)
				{
					ret.addAttribute(data.getKey(), data.getValue());
				}
			}
		}
		
		Collection<FormField<T>> ff = form.getFields(ctx);
		
		if(null != ff)
		{
			//TODO
		}
		
		return ret;
	}
}
