package eu.javaexperience.web.elements.form;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map.Entry;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetByTools;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.HTTPRequestMethod;

public class SimplifiedFormModel<T> extends SimplifiedHtmlModel<T>
{
	protected GetBy1<HTTPRequestMethod, T> method;
	protected GetBy1<String, T> action;
	
	protected GetBy1<Collection<FormField<T>>, T> fields;
	
	@SafeVarargs
	public static <T> SimplifiedFormModel<T> createSimple
	(
		@MayNotNull HTTPRequestMethod method,
		@MayNull String action,
		@MayNull String id,
		@MayNull String classes,
		@MayNull Collection<Entry<String,String>> dataset,
		FormField<T>... fields
	)
	{
		SimplifiedFormModel<T> ret = new SimplifiedFormModel<>();
		
		if(null == method)
		{
			method = HTTPRequestMethod.POST;
		}
		
		ret.setMethodFixed(method);
		ret.setActionFixed(action);
		ret.setIdFixed(id);
		ret.setClassesFixed(classes);
		ret.setDatasetFixed(dataset);
	
		Collection<FormField<T>> f= Arrays.asList(fields);
		ret.setFieldsFixed(f);
		
		return ret;
	}



	public GetBy1<HTTPRequestMethod, T> getMethod()
	{
		return method;
	}
	
	public HTTPRequestMethod getMethod(T ctx)
	{
		return method.getBy(ctx);
	}
	
	public void setMethod(GetBy1<HTTPRequestMethod, T> method)
	{
		this.method = method;
	}
	
	public void setMethodFixed(HTTPRequestMethod method)
	{
		AssertArgument.assertNotNull(method, "method");
		this.method = GetByTools.alwaysReturnWith(method);
	}



	public GetBy1<String, T> getAction()
	{
		return action;
	}
	
	public String getAction(T ctx)
	{
		return GetByTools.tryGet(action, ctx);
	}
	
	
	public void setAction(GetBy1<String, T> action)
	{
		this.action = action;
	}
	
	public void setActionFixed(String action)
	{
		if(null == action)
		{
			this.action = null;
		}
		else
		{
			this.action = GetByTools.alwaysReturnWith(action);
		}
	}






	public GetBy1<Collection<FormField<T>>,T > getFields()
	{
		return fields;
	}
	
	public Collection<FormField<T>> getFields(T ctx)
	{
		return GetByTools.tryGet(fields, ctx);
	}
	
	public void setFields(GetBy1<Collection<FormField<T>>,T > fields)
	{
		this.fields = fields;
	}
	
	public void setFieldsFixed(Collection<FormField<T>> fields)
	{
		if(null == fields)
		{
			this.fields = null;
		}
		else
		{
			this.fields = GetByTools.alwaysReturnWith(fields);
		}
	}
}
