package eu.javaexperience.web.elements.form;

import java.util.Collection;
import java.util.Map.Entry;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetByTools;

public class SimplifiedHtmlModel<T>
{
	protected GetBy1<String, T> id;
	protected GetBy1<String, T> classes;
	
	protected GetBy1<Collection<Entry<String, String>>, T> dataset;
	
	public GetBy1<String, T> getId()
	{
		return id;
	}
	
	public String getId(T ctx)
	{
		return GetByTools.tryGet(id, ctx);
	}
	
	public void setId(GetBy1<String, T> id)
	{
		this.id = id;
	}
	
	public void setIdFixed(String id)
	{
		if(null == id)
		{
			this.id = null;
		}
		else
		{
			this.id = GetByTools.alwaysReturnWith(id);
		}
	}



	public GetBy1<String, T> getClasses()
	{
		return classes;
	}
	
	public String getClasses(T ctx)
	{
		return GetByTools.tryGet(classes, ctx);
	}
	
	public void setClasses(GetBy1<String, T> classes)
	{
		this.classes = classes;
	}
	
	public  void setClassesFixed(String classes)
	{
		if(null == classes)
		{
			this.classes = null;
		}
		else
		{
			this.classes = GetByTools.alwaysReturnWith(classes);
		}
	}



	public GetBy1<Collection<Entry<String,String>>, T> getDataset()
	{
		return dataset;
	}
	
	public Collection<Entry<String, String>> getDataset(T ctx)
	{
		return GetByTools.tryGet(dataset, ctx);
	}
	
	public void setDataset(GetBy1<Collection<Entry<String,String>>, T> dataset)
	{
		this.dataset = dataset;
	}
	
	public void setDatasetFixed(Collection<Entry<String,String>> dataset)
	{
		if(null == dataset)
		{
			this.dataset = null;
		}
		else
		{
			this.dataset = GetByTools.alwaysReturnWith(dataset);
		}
	}
}
