package eu.javaexperience.web.facility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.fw.AbstractUser;
import eu.javaexperience.web.fw.SiteUserAndGroupManager;
import eu.javaexperience.web.server.commons.LightningConnectionClosed;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;

/**
 * 
 * Függ:
 * 	környezet
 * 	munkamenet
 * 	felhasználó
 * 	sablonkezelő
 *	adatbázis
 * 
 * @author Dankó Dávid (info@ddsi.hu)
 * @company Dankó Dávid Szerver és Informatikai vállalkozás (E.V. 2011)
 * 
 * @created 2014/11
 * */
public class SiteFacility extends HttpServlet
{
	/**
	 * Útvonalak
	 *
	 * Tartalomkezelő aminek minden eleme GenericStorable, így adva a lehetőség hogy egy weboldal csupán az őt kezelő kontrollerekből
	 * és adatbázisból felépíthető. A sitestruktúra, az oldalak mind az adatábizisban vannak, ezáltal szerkezetük deklarálva van.
	 * A felépítés megpróbálja a SEO elveket követni. 
	 * 
	 * 	http://www.pelda.hu/cikkek/seo/a-seo-url-anatomia#felepites
	 * 	www: subdomain
	 * 	pelda: doamin
	 * 	hu: TLD
	 * 	cikkek: útvonal (controller)
	 * 	seo: útvonal (paraméter/controller)
	 *  a-seo-url-anatomia: oldal (paraméter)
	 *  felepites: horgony
	 *  
	 *  http://webaruhaz.pelda.hu/eladok/szupervigyor/cikkek/olalak/12/?rendez=szerzo_a_z
	 *  
	 *  eladok: útvonal (controller)
	 *  szupervigyor: útvonal (paraméter)
	 *  cikkek: útvonal (paraméter/kontroller)
	 *  rendez: paraméter
	 * 
	 * */

	/**
	 * URLNode
	 * 
	 * Az az absztrakt osztály amely az URL-ben lévő egy utvonalelemet kezel.
	 * Az URLNode nyilvántartja hogy "kik" a szülei és gyerekei, ki a kanonikus szülője, ez később fontos lesz.
	 * 
	 * */
	

	/**
	 * Tartalomforrás
	 * olyan elem ami URLNode és Kontroller is  
	 * nyilvántartja a 
	 * 
	 * 
	 * */
	
	/**
	 * Ez lesz a konetxtus alapú modell
	 * kontextus = domain + url útvonal + url paraméterek  ¬ hashmark!
	 * 				+ sütik + auth + belső session változók
	 * 
	 * */
	
	
	/**
	 * Kérelem kiszolgálása
	 * egy bejövő kérelemből beolvassuk az URL-t, amit a kezdő URL-node-nak odaadunk, ők egymás között adogatják,
	 * az egyes nodeok "leszedegetik" a hozzájuk tartozó rész majd továbbadják a következő illeszkedő nodenak.
	 * 
	 * */
	
	/**
	 * Kiszolgálás folyamata:
	 * 
	 * a kérelem szétbontása után (domain és path elemekre) a következő szerint végigmegy a feldolgozáson:
	 * http://blog.ddsi.hu/cimke/cikkek/informatika/url-felbontas
	 * 
	 * természetes halmazok alapján (ahhol egyik elem teljes részhalmaza a másiknak)
	 * node lista:
	 * 	hu	ddsi	blog	cimke	cikkek	informatika	url-felbontás
	 * 
	 * hu:		környezeti változó lang=hu
	 * ddsi:	tartalom csatoló
	 * blog:	tartalom csatoló
	 * cimke:	tartalom csatoló
	 * cikkek:	$+1 témában $+2 névvel kérem a címet, majd kiszolgálás
	 * 
	 * */
	
	public SiteFacility(SiteObjectSettings settings)
	{
		settings.owner = this;
		sessionCookieName = settings.sessionCookieName;
		userAndGroupManager = settings.usrGrpManager;
		if(userAndGroupManager != null)
		{
			userAndGroupManager.init(this);
		}
		
		cookieDomain = settings.cookieDomain;
		cookiePath = settings.cookiePath;
		cookieExpiry = settings.sessionTimeoutSecounds;
		onSessionDestory = settings.onSessionDestory;
		onNewSession = settings.onNewSession;
		onSessionReborn = settings.onSessionReborn;
		exceptionHandler = settings.exceptionHandler;
		beforeViewApply = settings.beforeViewApply;
		this.sessionManager = settings.sessionManager;
		this.afterRequestEnd = settings.afterRequestEnd;
		this.beforeHeaderSent = settings.beforeHeaderSent;
		this.createContext = settings.createContext;
		this.beforeRequestProcess = settings.beforeRequestProcess;
		this.templateManager = settings.templateManager;
		this.unserved = settings.unserved;
		
		if(settings.afterOwnerSet != null)
			((SimplePublish1<SiteFacility>)settings.afterOwnerSet).publish(this);
		
	}
	
	public static class SiteObjectSettings
	{
		public SimplePublish1<Context> beforeHeaderSent;

		SiteFacility owner;
		
		public SiteFacility getOwner()
		{
			return owner;
		}
		
		public SimplePublish1<SiteFacility> afterOwnerSet;
		
		public GetBy3<? extends Context, SiteFacility, HttpServletRequest, HttpServletResponse> createContext; 
		
		public SimplePublish1<Context> beforeViewApply;

		public SimplePublish1<Context> exceptionHandler;

		public String sessionCookieName;
		
		public SimplePublish1<Context> beforeRequestProcess;
		
		public SiteUserAndGroupManager usrGrpManager;
		
		public String cookieDomain;
		
		public TemplateManager templateManager;
		
		public String cookiePath;
		
		public SimplePublish1<Session> onNewSession;
		
		public SimplePublish1<Session> onSessionDestory;
		
		public SimplePublish2<Session,AbstractUser> onSessionReborn;
		
		public SimplePublish1<Context> afterRequestEnd;
		
		public SimplePublish1<Context> unserved;
		
		public SessionManager sessionManager;
		
		public int sessionTimeoutSecounds;

		public String uploadTmpDir;

	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected ArrayList<Dispatcher> rootDispatchers = new ArrayList<>();
	
	protected final SiteUserAndGroupManager userAndGroupManager;
	
	protected String sessionCookieName;
	
	public String getSessionCookieName()
	{
		return sessionCookieName;
	}
	
	protected TemplateManager templateManager;
	
	protected final String cookieDomain;
	
	private GetBy3<? extends Context, SiteFacility, HttpServletRequest, HttpServletResponse> createContext; 
	
	public String getCookieDomain()
	{
		return cookieDomain;
	}
	
	protected final String cookiePath;
	
	public String getCookiePath()
	{
		return cookiePath;
	}
	
	protected int cookieExpiry;
	
	public int getCookieExpiry()
	{
		return cookieExpiry;
	}
	
	public SimplePublish1<Session> onNewSession;
	
	public SimplePublish1<Session> onSessionDestory;
	
	/**
	 * Meghívódik mielőtt még a session felöltené az új felhasználó azonosságát.
	 * */
	public SimplePublish2<Session,AbstractUser> onSessionReborn;
	
	public SiteUserAndGroupManager getUserAndGroupManager()
	{
		return userAndGroupManager;
	}
	
	/**
	 * Kitörli a sessiont és törölteti a cookie-t
	 * */
	public void destorySession(Context ctx)
	{
		sessionManager.destroySession(ctx);
	}
	
/*	public void applyNobodySession(Context ctx)
	{
		sessionManager.applyNobodySession(ctx);
	}
	
	public void applySession(AbstractUser usr,Context ctx)
	{
		sessionManager.applySession(this,usr,ctx);
	}
*/	
	public void addRootDispatcher(Dispatcher node)
	{
		if(rootDispatchers.contains(node))
		{
			return;
		}
		
		rootDispatchers.add(node);
	}
	
	public void removeRootNode(Dispatcher node)
	{
		rootDispatchers.remove(node);
	}
	
/*	public void setRootForward(SimplePublish1<Context> af)
	{
		ArrayList<Throwable> re = null;
		for(URLNode n: rootNodes)
		try
		{
			n.setSimplePublish1<Context>Forward(af);
		}
		catch(Exception e)
		{
			if(re == null)
				re = new ArrayList<>();
				
			re.add(e);
		}
		
		if(re != null)
			throw new UncheckedMultipleException(re);
	}
*/	
	public AbstractUser newUserInstance(String username)
	{
		return userAndGroupManager.createUser(username, null);
		//return SiteUser.newInstance(this, username);
	}
/*	
	public SiteGroup newGroupInstance(String groupname)
	{
		return SiteGroup.newInstance(groupname);
	}
*/
	protected SimplePublish1<Context> unserved;
	
	public SimplePublish1<Context> getUnservedHandler(SimplePublish1<Context> eff)
	{
		return unserved;
	}
	
	public void setUnservedHandler(SimplePublish1<Context> eff)
	{
		unserved = eff;
	}
	
	protected SimplePublish1<Context> exceptionHandler;
	
	public SimplePublish1<Context> getSiteObjectExceptionHandler(SimplePublish1<Context> eff)
	{
		return exceptionHandler;
	}
	
	public void setSiteObjectExceptionHandler(SimplePublish1<Context> eff)
	{
		exceptionHandler = eff;
	}
	
	protected SimplePublish1<Context> beforeRequestProcess;
	
	public SimplePublish1<Context> getBeforeRequestProcess()
	{
		return beforeRequestProcess;
	}

	private SimplePublish1<Context> afterRequestEnd;
	
	public SimplePublish1<Context> getAfterRequestEnd()
	{
		return afterRequestEnd;
	}

	public void setAfterRequestEnd(SimplePublish1<Context> afterRequestEnd)
	{
		this.afterRequestEnd = afterRequestEnd;
	}
	
	public void setBeforeRequestProcess(SimplePublish1<Context> beforeReqestProcess)
	{
		this.beforeRequestProcess = beforeReqestProcess;
	}

	protected SimplePublish1<Context> beforeViewApply;
	
	public SimplePublish1<Context> getBeforeViewApply()
	{
		return beforeViewApply;
	}

	public void setBeforeViewApply(SimplePublish1<Context> ae)
	{
		beforeViewApply = ae;
	}
	
	/**
	 * TODO
	 * 	list session
	 * 	invalidate session
	 * 
	 * 
	 * 
	 * */
	
	protected SimplePublish1<Context> beforeHeaderSent;
	
	public SimplePublish1<Context> getBeforeHeaderSent()
	{
		return beforeHeaderSent;
	}
	
	public String getSessionStringBySession(Session sess)
	{
		return sessionManager.getSessionStringBySession(sess);
	}
	
/*	public Session getSiteObjectSession(HttpServletRequest req)
	{
		return sessionManager.getSiteObjectSession(this, req);
	}
*/	
	/**
	 * szerver oldali sessionok közül kiveszi de a kliensnek nem küldi el a süti törlését
	 * */
	public void destroySession(String str)
	{
		sessionManager.destroySession(str);
	}
	
//	protected Map<String,SiteObjectSession> sessions = new ConcurrentHashMap<>();
	protected SessionManager sessionManager;
	
	/**
	 * És ezzel fogajduk az összes kérelmet,típustól függetlenül (GET,POST,HEAD,...)
	 * */
	public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException
	{
		Context ctx = null;
		try
		{
			ctx = createContext.getBy(this, req, resp);//new RequestContext(this, req, resp);//,getSiteObjectSession(req)
		}
		catch(Throwable e)
		{
			e.printStackTrace();
			return;
		}
		
		if(!dispatch(ctx))
		{
			if(unserved != null)
			{
				unserved.publish(ctx);
			}
		}
	}
	
	public boolean dispatch(Context ctx)
	{
		SiteFacilityTools.setCurrentContext(ctx);
		
		//sok csekkolás: be van-e jelentkezve, mi az URL vége (TLD és nyelve)
		//header => nyelv (vagy inkávbb root doamin? hu.asdasd.)
		//root url meghatározása
		try
		{
			if(beforeRequestProcess != null)
				beforeRequestProcess.publish(ctx);
			
			for(Dispatcher n:rootDispatchers)
			{
				if(n.dispatch(ctx))
				{
					return true;
				}
			}
			
			//SikeresKikuldesKivetelt dob, ha kiszolgálta, ha nem akkor unservedet híjvuk.
			
			return false;
			//ctx.getResponse().flushBuffer();
		}
		catch(OperationSuccessfullyEnded skk)
		{//a válasz sikeresen ki lett küldve!
			return true;
		}
		/*catch(IOException ioe)
		{//A kapcsolat menet közben bezárult... nothing to do
			ioe.printStackTrace();
			return false;
		}*/
		catch(StackOverflowError soe)
		{// valószinüleg egy URLNode vagy HElement vagy más magára hivatkozott.
			soe.printStackTrace();
		}
		catch(Throwable soe)
		{//portál hiba, naplózni és hivatkozni.
			//vagy nem volt elegendő jog.
				//vagy ilyesmi
					//Ezeket a kivételeket StackTrace Alapján el lehet tárolni és számolni hogy hányszor fordult elő.
			
			try
			{
				//soe.printStackTrace();
				ctx.setProcessException(soe);
				tryHandleException(soe, ctx);
				
			//	soe.printStackTrace();
			}	
			catch(OperationSuccessfullyEnded skk)
			{//a válasz sikeresen ki lett küldve!
				return true;
			}
			catch(IOException ioe)
			{//A kapcsolat menet közben bezárult... nothing to do
				ioe.printStackTrace();
				return false;
			}
			catch(StackOverflowError soex)
			{// valószinüleg egy URLNode vagy HElement vagy más magára hivatkozott.
				
				soex.printStackTrace();
			}
			catch(SiteFacilityException soee)
			{
				soee.printStackTrace();
			}
			catch(Exception e)
			{}
		}
	/*	catch(Throwable t)
		{
			System.out.println(ctx.requestURL);
			t.printStackTrace();
		}*/
		finally
		{
			try
			{
				if(afterRequestEnd != null)
				{
					afterRequestEnd.publish(ctx);
				}
			}
			catch(Throwable t)
			{
				//TODO
				t.printStackTrace();
			}
			SiteFacilityTools.setCurrentContext(null);
		}
		
		return false;
	}
	
	private void tryHandleException(Throwable e,Context ctx) throws Exception
	{
		/*for(int i=0;i<10 && e instanceof sun.org.mozilla.javascript.WrappedException;i++)
			e = e.getCause();*/
		
		ctx.setProcessException(e);
		
		//if(e instanceof SiteObjectException)
		if(exceptionHandler != null)
		{
			exceptionHandler.publish(ctx);
		}
	}
	
	private static final OperationSuccessfullyEnded skk = OperationSuccessfullyEnded.instance;
	
	public static void finishOperation()
	{
		throw skk;
	}
	
	public TemplateManager getTemplateaManger()
	{
		return templateManager;
	}
	
	public Template getView(String view)
	{
		return templateManager.getView(view);
	}
	
	protected SmallMap<String,Object> params = new SmallMap<>();
	
	public void addDefaultParameter(String key,Object val)
	{
		params.put(key,val);
	}
	
	public Map<String,Object> getDefaultEnv()
	{
		//Az alapvető cuccok bepakolása
		//pl modelltár
		
		//globális beállítás
			
		
		
		
		
		return params.clone();
	}

/*	public Session sessionReborn(Context ctx, AbstractUser usr)
	{
		Session sess = sessionManager.reborn(this, ctx.getSession(), usr); 
		//TODO ctx.setSession(sess);
		return sess;
	}
*/	
	public SessionManager getSessionManager()
	{
		return sessionManager;
	}

	public void setSessinCookieName(String sessionCookieName )
	{
		this.sessionCookieName = sessionCookieName;
	}
}