package eu.javaexperience.web.fw;

import eu.javaexperience.web.facility.SiteFacility;

public class ManagedUser implements AbstractUser
{
	protected final SiteFacility owner;
	protected final String username;
	
	public ManagedUser(SiteFacility owner, String username)
	{
		this.owner = owner;
		this.username = username;
	}
	
	@Override
	public String getUsername()
	{
		return username;
	}

	@Override
	public AbstractGroup[] getGroups()
	{
		return owner.getUserAndGroupManager().getGroupsOfUser(this);
	}

	@Override
	public SiteFacility getOwnerSiteObject()
	{
		return owner;
	}

	@Override
	public void setPassword(String passwd)
	{
		owner.getUserAndGroupManager().setPassword(this, passwd);
	}

	@Override
	public boolean isPassword(String passwd)
	{
		return owner.getUserAndGroupManager().isPassword(this, passwd);
	}

	@Override
	public void addGroup(AbstractGroup grp)
	{
		owner.getUserAndGroupManager().addUserToGroup(this, grp);
	}

	@Override
	public void removeGroup(AbstractGroup grp)
	{
		owner.getUserAndGroupManager().removeUserFromGroup(this, grp);
	}

	@Override
	public Object getExtraInfo(String key) throws Exception
	{
		return owner.getUserAndGroupManager().getUserExtraInfo(this, key);
	}

	@Override
	public void setExtraInfo(String key, Object o) throws Exception
	{
		owner.getUserAndGroupManager().setUserExtraInfo(this, key, o);
	}
}
