package eu.javaexperience.web.fw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Normalizer;
import java.text.Normalizer.Form;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.ServletOutputStream;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.text.Format;
import eu.javaexperience.time.TimeCalc;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpResponseStatusCode;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.URLLink;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.elements.ClonePageFactory;
import eu.javaexperience.web.elements.ClonedPage;
import eu.javaexperience.web.elements.HElement;
import eu.javaexperience.web.elements.HtmlPart;
import eu.javaexperience.web.elements.Tag;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.fw.permission.SiteOwnableObject;
import eu.javaexperience.web.fw.template.dom.HElementTemplate;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateContainer;

public class SiteObjectTools
{
	public static int parseIntOrReportError(Context ctx, String val,String reportField,String reportText) throws Exception
	{
		try
		{
			return Integer.parseInt(val);
		}
		catch(Exception e)
		{
			SiteFacilityTools.finishWithLastViewSet(ctx, reportField, reportText);
			return -1;
		}
	}
	
	public static long parseLongOrReportError(Context ctx, String val,String reportField,String reportText) throws Exception
	{
		try
		{
			return Long.parseLong(val);
		}
		catch(Exception e)
		{
			SiteFacilityTools.finishWithLastViewSet(ctx, reportField, reportText);
			return -1;
		}
	}
	
/*	public static <T extends GenericStorable> T lookupStoredByIdOrReportError(RequestContext Class<T> cls,long id,GenericStoreDatabase db,String reportField,String reportText) throws Exception
	{
		try
		{
			return GenericStorage.getObjectByIDDescendantOf(id, cls, db);
		}
		catch(Exception e)
		{
			finishWithLastViewSet( reportField, reportText);
			return null;
		}
	}
*/	
	
	public static String identityhttpRedirectMetaSzekcio = "url";
	
	public static final ClonePageFactory httpRedirect = new ClonePageFactory
	(
		Tag.doctypeHtml.newInstance().addHElements
		(
			Tag.head.newInstance().addHElements
			(
				new HtmlPart(identityhttpRedirectMetaSzekcio).addHElements
				(
					Tag.meta.newInstance().addAttribute("http-equiv", "refresh")
				)
			)
		)
	);
	
	public static final Template hianyzoView = new HElementTemplate(new ClonePageFactory(Tag.span.newInstance().setText("Hiányzó view.")));
	
	public static void htmlRedirect(Context ctx, String path)
	{
		ClonedPage root = httpRedirect.clone();
		root.getByJel(identityhttpRedirectMetaSzekcio).addAttribute("content", "0;url="+path);
		try
		{
			root.getRoot().append(ctx.getResponse().getWriter());
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
		ctx.finishOperation();
	}
	
	public static Object evalCompiledScript(CompiledScript js, Object disz) throws ScriptException
	{
		Context ctx = SiteFacilityTools.getCurrentContext();
		Bindings b = js.getEngine().createBindings();
		b.put("this", disz);
		b.put("disz", disz);
		b.put("ctx", ctx);
		return js.eval(b);
	}
	
		

	
	/**
	 * bejegyzi a megadott útvonalakat és visszatér azok végpontjaival.
	 * Ha már létezik az adott URLNode akkor nem adájk még egyszer hozzá, összefűzik vele
	 * */
/*	public static ArrayList<URLNode> registerRootNodesWithMerge(URL[] urls, SiteObject so)
	{
		ArrayList<URLNode> ret = new ArrayList<>();

		for(URL u:urls)
		{
			PreparedURL url = new PreparedURL(u);
			String e = url.getCurrentURLElement();
			SimpleURLNode n = new SimpleURLNode(e);
			so.setOwner(n);
			so.addRootNode(n);
			
			while(url.hasNextURLElement())
			{
				e = url.jumpNextURLElement();
				SimpleURLNode g = new SimpleURLNode(e);	
				n.addChild(g);
				n = g;
			}

			ret.add(n);
		}
		
		return ret;
	}
*/	
	public static void finishWithElementSend(Context ctx, HElement ele)
	{
		SiteFacilityTools.tryCallBeforeHeaderSent(ctx);
		
		try
		{
			ele.append(ctx.getResponse().getWriter());
			ctx.getResponse().getWriter().flush();
		}
		catch(Exception e)
		{
			throw new RuntimeException(e);
		}
		ctx.finishOperation();
	}
	
	/***************************************************************************
	 * 
	 *					Permissions 
	 *
	 **************************************************************************/
	public static int AbstractUser_READ = 0b10000000;
	public static int AbstractUser_WRITE = 0b01000000;
	
	public static int GROUP_READ = 0b00100000;
	public static int GROUP_WRITE = 0b00010000;
	
	public static int OTHER_READ = 0b00001000;
	public static int OTHER_WRITE = 0b00000100;
	
	private static void setPerm(SiteOwnableObject obj,boolean r,int perm)
	{
		int permission = obj.getPermission();
		
		if(r)
			permission |= perm;
		else
			permission &= ~perm;
		
		obj.setPermission(permission);
	}
	
	public static void setUserRead(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, AbstractUser_READ);
	}

	public static void setUserWrite(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, AbstractUser_WRITE);
	}
	
	public static void setGroupRead(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, GROUP_READ);
	}

	public static void setGroupWrite(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, GROUP_WRITE);
	}

	public static void setOtherRead(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, OTHER_READ);
	}

	public static void setOtherWrite(SiteOwnableObject obj,boolean r)
	{
		setPerm(obj, r, OTHER_WRITE);
	}	
	
	private static boolean hasPermission(SiteOwnableObject obj,int perm)
	{
		return (obj.getPermission() & perm) == perm;
	}
	
	public static boolean hasUserReadPermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, AbstractUser_READ);
	}
	
	public static boolean hasUserWritePermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, AbstractUser_WRITE);
	}

	public static boolean hasGroupReadPermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, GROUP_READ);
	}
	
	public static boolean hasGroupWritePermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, GROUP_WRITE);
	}

	public static boolean hasOtherReadPermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, OTHER_READ);
	}
	
	public static boolean hasOtherWritePermission(SiteOwnableObject obj)
	{
		return hasPermission(obj, OTHER_WRITE);
	}
	
/*	public static boolean canRead(SiteOwnableObject obj, Context ctx)
	{
		if(hasOtherReadPermission(obj))
			return true;
		
		if(ctx.getOwnerSiteObject() != obj.getOwner())
			throw new RuntimeException("CrossSiteElement");

		AbstractUser usr = ctx.getUser();
		
		if("nobody".equals(usr.getUsername()))
			return hasUserReadPermission(obj);
		else if(obj.getUser().equals(usr.getUsername()))
			if(hasUserReadPermission(obj))
				return true;
		
		String ownerGroup = obj.getGroup();
		
		for(AbstractGroup g:usr.getGroups())
			if(ownerGroup.equals(g.getGroupname()))
				return hasGroupReadPermission(obj);
		
		return false;
	}

	public static boolean canWrite(SiteOwnableObject obj,Context ctx)
	{
		if(hasOtherWritePermission(obj))
			return true;
		
		if(ctx.getOwnerSiteObject() != obj.getOwner())
			throw new RuntimeException("CrossSiteElement");

		AbstractUser usr = ctx.getUser();
		
		if("nobody".equals(usr.getUsername()))
			return hasUserWritePermission(obj);
		else if(obj.getUser().equals(usr.getUsername()))
			if(hasUserWritePermission(obj))
				return true;
		
		String ownerGroup = obj.getGroup();
		
		for(AbstractGroup g:usr.getGroups())
			if(ownerGroup.equals(g.getGroupname()))
				return hasGroupWritePermission(obj);
		
		return false;
	}
	
	public static boolean canReadWrite(SiteOwnableObject obj,Context ctx)
	{
		if(hasOtherReadPermission(obj) && hasOtherWritePermission(obj))
			return true;
		
		if(ctx.getOwnerSiteObject() != obj.getOwner())
			throw new RuntimeException("CrossSiteElement");

		AbstractUser usr = ctx.getUser();
		
		if("nobody".equals(usr.getUsername()))
			if(hasUserReadPermission(obj) && hasUserWritePermission(obj))
				return true;
		else if(obj.getUser().equals(usr.getUsername()))
			if(hasUserReadPermission(obj) && hasUserWritePermission(obj))
				return true;
		
		String ownerGroup = obj.getGroup();
		
		for(AbstractGroup g:usr.getGroups())
			if(ownerGroup.equals(g.getGroupname()))
				return hasGroupReadPermission(obj) && hasGroupWritePermission(obj);
		
		return false;
	}
	
	public static boolean tryLogin(Context ctx)
	{
		SiteObject so = ctx.getOwnerSiteObject();
		String user = ctx.getRequest().getParameter("login_username");
		String passwd = ctx.getRequest().getParameter("login_password");
		AbstractUser usr = so.getUserAndGroupManager().getUserByUsername(user);
		if(usr == null)
			return false;
		
		if(usr.isPassword(passwd))
		{
			so.applySession(usr, ctx);
			return true;
		}
		
		return false;
	}
	
	public static Session sessionStart(Context ctx)
	{
		ctx.getOwnerSiteObject().getSessionManager().applyNobodySession(ctx);
		return ctx.getSession();
	}
	
	public static void logout(Context ctx)
	{
		ctx.getOwnerSiteObject().destorySession(ctx);
	}
	
	public static boolean isLoginProcess(Context ctx)
	{
		return 	ctx.getRequest().getParameter("login_username") != null && ctx.getRequest().getParameter("login_password") != null;
	}
	
	public static boolean isValidUserLoggedIn(Context ctx)
	{
		return !ctx.getOwnerSiteObject().getUserAndGroupManager().getNobodyUser().equals(ctx.getUser());
	}
	*/
	
	public static final long startTime = HttpTools.getWebDate(System.currentTimeMillis());
}