package eu.javaexperience.web.fw;

import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityException;

public interface SiteUserAndGroupManager
{
	public void init(SiteFacility so);
	
	/**
	 * returns null if user already exists
	 * */
	public AbstractUser createUser(String username,@MayNull String password) throws SiteFacilityException;
	public AbstractGroup createGroup(String group);
	
	
	/**
	 * null ha sikertelen
	 * */
	public AbstractUser login(String username,String password) throws SiteFacilityException;
	public boolean isPassword(AbstractUser usr,String passwd) throws SiteFacilityException;
	public void setPassword(AbstractUser usr,String password) throws SiteFacilityException;

	public AbstractUser getUserByUsername(String username) throws SiteFacilityException;
	
	public AbstractGroup[] getGroupsOfUser(AbstractUser usr) throws SiteFacilityException;
	public boolean isUserInGroup(AbstractUser usr,AbstractGroup grp) throws SiteFacilityException;
	public void addUserToGroup(AbstractUser usr,AbstractGroup grp) throws SiteFacilityException;
	public void removeUserFromGroup(AbstractUser usr,AbstractGroup grp) throws SiteFacilityException;
	
	public AbstractGroup getGroupByGroupname(String name) throws SiteFacilityException;
	
	public Object getUserExtraInfo(AbstractUser su,String key);
	
	public void setUserExtraInfo(AbstractUser su, String key, Object val);
	
	public Object getGroupExtraInfo(AbstractGroup grp,String key);
	
	public void setGroupExtraInfo(AbstractGroup grp, String key, Object val);
	
	
	/**
	 * Törekedj a leggyorsabb visszadásra mivel minden kérelemnél lefut ha nem sikerült sessionból előhalászni a usert akkor ez hívódik meg
	 * Mindenképp adj vissza Nobody User-t célszerű egy belső változóban tárolni amit at init hívásánal inicializálsz, ha hiba lépett fel ott dobj kivételt
	 * */
	public AbstractUser getNobodyUser();
	public AbstractGroup getNobodyGroup();
	
}