package eu.javaexperience.web.fw;

import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.text.Format;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.server.binding.HttpQueryContext;
import eu.javaexperience.web.server.binding.HttpRequest;
import eu.javaexperience.web.server.binding.HttpServingTimeMetric;
import eu.javaexperience.web.session.InMemorySessionManager;

/**
 * Sablon felületet nyujt a SiteObject-hez, néhány alap feladatot ellát:
 * 		adatbázisból dolgozik, ha nem létezik még admin felhasználó létrehozza.
 * 		az átadott útvonalakat bejegyzi
 * 		kezeli a sablon oldal alapszerkezetet
 * 		javascript és CSS gyüjtést és kezelést valósít meg.
 * 
 * 		Kell egy admin felület is
 * 
 * */
public class TemplateWebsite extends SiteFacility
{
	public TemplateWebsite(SiteObjectSettings settings)
	{
		super(settings);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static class TemplateWebsiteSettings extends SiteObjectSettings
	{
		public URL[] rootPaths;
		
		{
			//mik vannak
			afterOwnerSet = null;//all.afterOwnerSet();
			afterRequestEnd = null;//(Interfere<>)all.afterRequestEnd();
			beforeHeaderSent = null;
			beforeRequestProcess = null;
			beforeViewApply = null;
			cookieDomain = null;
			cookiePath = null;
			createContext = null;
			exceptionHandler = null;
			onNewSession = null;
			onSessionDestory = null;
			onSessionReborn = null;
			rootPaths = null;
			sessionCookieName = null;
			sessionManager = new InMemorySessionManager();
			sessionTimeoutSecounds = 0;
			templateManager = null;
			uploadTmpDir = null;
			usrGrpManager = null;
		}
		
	}

	protected List<URLNode> endpoints = new Vector<>(); 
	
	public void attachToBeginUrls(URLNode node)
	{
		for(URLNode n:endpoints)
			n.addChild(node);
	}
	
	/**
	 * Az átadott node-tól kiindulva, rekurzívan megkeresi azt a pontot amivel a leghosszabban egyezik,
	 * visszatér a legutolsó URLNode-val amivel még egyetezik.
	 * null-t ad vissza ha az adott ágon nincs egyezés
	 * */
/*	private URLNode tryMatch(URLNode node,List<String> lst, int i)
	{
		if(!node.canHandleRequest(lst.get(i)))//nem illeszkedik
			return null;
		
		if(lst.size()-1 <= i)//nincs több lépés előre
			return node;
		
		URLNode ret = node;
		int rd = i;
		for(URLNode n:node.childs())
		{
			URLNode r = tryMatch(n, lst, i+1);
			
			if(r == null)
				continue;
			
			int d = r.depth();
			if(d > rd)
			{
				ret = r;
				rd = r.depth();
			}
		}
		
		return ret;
	}
*/	
	/**
	 * Naplóbejegyzés kiiratása:
	 * 
	 * 127.0.0.1:45634 | 2016-06-21 13:51:02.342 | feldolgozási idők | E/Y | USER | GET | 301 | reqURL
	 * 
	 * Format.sqlTimestampMilisec
	 * 
	 * */
	public static SimplePublish1<Context> logAfterRequestEnd(final SimpleGet<? extends Appendable> appendable)
	{
		return new SimplePublish1<Context>()
		{
			@Override
			public void publish(Context ctx)
			{
				Appendable out = appendable.get();
				if(null != out)
				{
					StringBuilder app = new StringBuilder();
					try
					{
						HttpServletRequest req = ctx.getRequest();
						HttpServletResponse resp = ctx.getResponse();
						
						//távoli cím
						app.append(req.getRemoteAddr());
						
						HttpQueryContext lsrr = null;
						if(ctx.getRequest() instanceof HttpRequest)
						{
							lsrr = ((HttpRequest)ctx.getRequest()).getQuery();
						}
						
						if(null != lsrr)
						{
							long requestHandlingStartTime = lsrr.getTimeMetric(HttpServingTimeMetric.RequestStart);
							long requestParseingEndTime = lsrr.getTimeMetric(HttpServingTimeMetric.RequestParse);
							long requestTemplateCompileStartTime = lsrr.getTimeMetric(HttpServingTimeMetric.DispatchAndLogic);
							app.append(" | ");
							app.append(Format.UTC_SQL_TIMESTAMP_MS.format(new Date(requestHandlingStartTime)));//kezdete
							app.append(" | ");
							//sorban: beolvasás vége, logika, teljes idő
							app.append(String.valueOf(requestParseingEndTime - requestHandlingStartTime));
							app.append(" | ");
							long dt = requestTemplateCompileStartTime - requestParseingEndTime;
							app.append(dt < 0?"-":String.valueOf(dt));
							app.append(" | ");
							app.append(String.valueOf(System.currentTimeMillis() - requestHandlingStartTime));
						}
						else
						{
							app.append(" | ");
							app.append(Format.sqlTimestampMilisec(new Date(System.currentTimeMillis())));
							app.append(" | ");
						}
						
						/*AbstractUser u = ctx.getUser();
						if(null != u)
						{
							app.append(" | ");
							app.append(u.getUsername());
						}*/
						
						app.append(" | ");
						app.append(req.getMethod());
						
						//hiba volt-e
						app.append(" | ");
						app.append(null != ctx.getProcessException()?"E":"Y");
						
						app.append(" | ");
						app.append(String.valueOf(resp.getStatus()));
						
						app.append(" | ");
						app.append(req.getRequestURL().toString());
						app.append("\n");
						
						out.append(app.toString());
					}
					catch(Exception e)
					{
						e.printStackTrace();
					}
				}
			}
		};
	}
	
	public static SimplePublish1<Context> beforeViewApplyLightningLogTemplateCompilationStartTime = new SimplePublish1<Context>()
	{
		@Override
		public void publish(Context ctx)
		{
			HttpQueryContext lsrr = null;
			if(ctx.getRequest() instanceof HttpRequest)
			{
				lsrr = ((HttpRequest)ctx.getRequest()).getQuery();
				lsrr.setTimeMetric(HttpServingTimeMetric.Render, System.currentTimeMillis());
			}
		}
	};
}