package eu.javaexperience.web.fw.permission;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import eu.javaexperience.semantic.designedfor.IdentityObject;
import eu.javaexperience.semantic.designedfor.InstanceSupervisor;
import eu.javaexperience.semantic.references.ContainsNotNull;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityException;
import eu.javaexperience.web.fw.AbstractGroup;
import eu.javaexperience.web.fw.AbstractUser;
import eu.javaexperience.web.fw.SiteUserAndGroupManager;

@InstanceSupervisor
public abstract class AbstractSiteUserAndGroupManager<U extends AbstractUser,G extends AbstractGroup> implements SiteUserAndGroupManager
{
	protected SiteFacility so;
	protected AbstractUser nobody;
	protected AbstractGroup nogroup;
	
	protected ConcurrentMap<String,U> users = new ConcurrentHashMap<>();
	
	protected ConcurrentMap<String,G> groups = new ConcurrentHashMap<>();

	
	protected abstract AbstractUser getNobody();

	protected abstract AbstractGroup getNogroup();

	protected abstract U loadUser(String usr_name);

	protected abstract G loadGroup(String grp_name);
	
	protected abstract U internalCreateUser(String username, String password);
	
	protected abstract void internalSetPassword(@MayNotNull U usr, @MayNotNull String passwd);
	
	protected abstract void internalRemoveUserFromGroup(@MayNotNull U user,@MayNotNull G group);
	
	protected abstract void internalAddUserToGroup(@MayNotNull U user,@MayNotNull G group);
	
	protected abstract boolean isUserPassword(@MayNotNull U user,@MayNotNull String passwd);
	
	
	
/*	@Comment(comment="Kiüríti a felhasználó és csoport gyorsítótárat")
	protected void flushCache()
	{
		users = new ConcurrentHashMap<>();
		groups = new ConcurrentHashMap<>();
	}
*/
	
	/*{
		if(usrName == null)
			return null;
		
		DatabaseSiteGroup ret = grps.get(usrName);
		if(ret != null)
			return ret;
		
		Iterator<DatabaseSiteGroup> it = null;
		try {
			it = GenericStorage.getObjectsByQuery(DatabaseSiteGroup.class, F.eq.is("groupname",usrName), so.getDatabase()).iterator();
		} catch (GenericStoreException e)
		{
			e.printStackTrace();
			System.err.println("Database Error");
			throw new SiteObjectException(Response._500_internal_server_error, SiteObject.getCurrentRequestContext(), new SimpleMessageGenericErrorCode("Adatbázis hiba"));
		}
		
		if(it.hasNext())
		{
			ret = it.next();
			grps.put(usrName, ret);
			return ret;
		}
		
		return null;
	}*/
	
	public static final AbstractUser defaultNobody = new AbstractUser()
	{
		@Override
		public void setPassword(String passwd)
		{
			throw new RuntimeException("Illegal modification on nobody user");
		}
		
		@Override
		public void setExtraInfo(String key, Object o) throws Exception
		{
			throw new RuntimeException("Illegal modification on nobody user");
		}
		
		@Override
		public void removeGroup(AbstractGroup grp)
		{
			throw new RuntimeException("Illegal modification on nobody user");			
		}
		
		@Override
		public boolean isPassword(String passwd)
		{
			return true;
		}
		
		@Override
		public String getUsername()
		{
			return "nobody";
		}
		
		@Override
		public SiteFacility getOwnerSiteObject()
		{
			return null;
		}
		
		@Override
		public AbstractGroup[] getGroups()
		{
			return emptyAbstractGroupArray;
		}
		
		@Override
		public Object getExtraInfo(String key) throws Exception
		{
			return null;
		}
		
		@Override
		public void addGroup(AbstractGroup grp)
		{
			throw new RuntimeException("Illegal modification on nobody user");			
		}
	};
	
	
	public static final AbstractGroup defaultNogroup = new AbstractGroup()
	{
		@Override
		public String getGroupname()
		{
			return "nogroup";
		}
	};
	
	/**
	 * returns with the requested user, identified by name.
	 * requesting multiple time the same user returns with the same reference of
	 * User Object.
	 * */
	public @IdentityObject U getUserByUsername(String name)
	{
		U re = users.get(name);
		if(re == null)
		{
			U ni = loadUser(name);
			if(ni == null)
				return null;
			
			re = users.putIfAbsent(name, ni);
			if(re == null)
				re = ni;
		}
		
		return re;
	}

/*	{
		if(usrName == null)
			return null;
		
		DatabaseSiteUser ret = usrs.get(usrName);
		if(ret != null)
			return ret;
		
		Iterator<DatabaseSiteUser> it = null;
		try {
			it = GenericStorage.getObjectsByQuery(DatabaseSiteUser.class, F.eq.is("username",usrName), so.getDatabase()).iterator();
		} catch (GenericStoreException e)
		{
			e.printStackTrace();
			System.err.println("Database Error");
			throw new SiteObjectException(Response._500_internal_server_error, SiteObject.getCurrentRequestContext(), new SimpleMessageGenericErrorCode("Adatbázis hiba"));
		}
		
		if(it.hasNext())
		{
			ret = it.next();
			usrs.put(usrName, ret);
			return ret;
		}
		
		return null;
	}
	*/
	
	@Override 
	public void setPassword(AbstractUser usr, String password)
	{
		if(usr == null || password == null)
			return;
		
		internalSetPassword((U) usr, password);
	}
	
	@Override
	public void removeUserFromGroup(AbstractUser usr, AbstractGroup grp)
	{
		if(usr == null || grp == null)
			return;
		
		internalRemoveUserFromGroup((U) usr, (G) grp);
	}
	
	@Override
	public U login(String username, String password)
	{
		if(username == null || password == null)
			return null;
		
		U usr = getUserByUsername(username);
		if(usr == null)
			return null;
		
		if(isUserPassword(usr, password))
			return usr;
		
		return null;
	}
	
	/**
	 * Generic function uses {@link AbstractUser#getGroups()} function
	 * note that the function handles the given {@link AbstractUser} and {@link AbstractGroup}
	 * as Object derived from implementation of this abstract class.
	 * No casting applied, but {@link AbstractGroup}s will be compared over
	 * equals(Object) method. 
	 * */
	@Override
	public boolean isUserInGroup(AbstractUser usr, AbstractGroup grp)
	{
		if(usr == null || grp == null)
			return false;
		
		U s = getUserByUsername(usr.getUsername());
		if(s == null)
			return false;
		
		AbstractGroup g = getGroupByGroupname(grp.getGroupname());
		if(g == null)
			return false;
		
		String gr = grp.getGroupname();
		
		for(AbstractGroup str:s.getGroups())
			if(gr.equals(str.getGroupname()))
				return true;
		
		return false;
	}
	
	@Override
	public boolean isPassword(AbstractUser usr, String passwd)
	{
		if(usr == null || passwd == null)
			return false;
		
		return isUserPassword((U) usr, passwd);
	}
	

	
	@Override
	public AbstractUser getNobodyUser()
	{
		return nobody;
	}
	
	@Override
	public AbstractGroup getNobodyGroup()
	{
		return nogroup;
	}
	
	@Override
	public G getGroupByGroupname(String name)
	{
		G re = groups.get(name);
		if(re == null)
		{
			G ni = loadGroup(name);
			if(ni == null)
				return null;
			
			re = groups.putIfAbsent(name, ni);
			if(re == null)
				re = ni;
		}
		
		return re;
	}
	
	@Override
	public U createUser(String username, String password)
	{
		if(username == null || password == null)
			return null;
		
		U ret = getUserByUsername(username);
		
		if(ret != null)//if already exists
			return null;

		U u = internalCreateUser(username, password);

		/**
		 * if already in map, user concurrently already registered
		 */
		if(users.putIfAbsent(username, u) != null)
			return null;
		
		return ret;
	}
	
	//TODO deleteUser, addUser, addGroup, delGroup a leszármazott számára, had tudja csak kívülről is buherálni.
	
	
	
	@Override
	public void addUserToGroup(AbstractUser usr, AbstractGroup grp)
	{
		if(usr == null || grp == null)
			return;
		
		if(usr.getUsername() == null || grp.getGroupname() == null)
			return;
		
		U user = getUserByUsername(usr.getUsername());
		G group = getGroupByGroupname(grp.getGroupname());
		
		internalAddUserToGroup(user, group);
	}
	
	@Override
	public void init(SiteFacility so)
	{
		this.so = so;
		nobody = getNobody();
		nogroup = getNogroup();
	}

	//TODO
	@Override
	public @MayNull G createGroup(@MayNotNull String group)
	{
		if(group == null)
			return null;
		
		G ret = getGroupByGroupname(group);
		if(ret != null)//ha létezik
			return null;

		G u = internalCreateGroup(group);
		return u;
	}

	protected abstract G internalCreateGroup(@MayNotNull String group);
	
	public static AbstractUser[] emptyAbstractUserArray = new AbstractUser[0];
	
	public static AbstractGroup[] emptyAbstractGroupArray = new AbstractGroup[0];
	
	@Override
	public @MayNotNull @ContainsNotNull AbstractGroup[] getGroupsOfUser(@MayNotNull AbstractUser usr) throws SiteFacilityException
	{
		U user = getUserByUsername(usr.getUsername());
		if(user == null)
			return emptyAbstractGroupArray;

		AbstractGroup[] grps = user.getGroups();
		AbstractGroup[] ret = new AbstractGroup[grps.length];
		for(int i=0;i<ret.length;i++)
		{
			if(grps[i] == null)
			{
				ret[i] = nogroup;
				continue;
			}
			
			AbstractGroup g = getGroupByGroupname(grps[i].getGroupname());
			if(g == null)
				ret[i] = nogroup;
			else
				ret[i] = g;
		}
		
		return ret;
	}
}
