package eu.javaexperience.web.fw.template.dom;

import java.io.IOException;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.semantic.designedfor.ThreadSafe;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.elements.ClonePageFactory;
import eu.javaexperience.web.fw.RetractedTemplate;

public class HElementTemplate implements RetractedTemplate
{
	protected final ClonePageFactory fact;
	
	public HElementTemplate(ClonePageFactory fact)
	{
		AssertArgument.assertNotNull(fact, "ClonaPageFactory");
		this.fact = fact;
	}
	
	public void render(Context ctx, Appendable app) throws IOException
	{
		fact.clone().getRoot().append(app);
	}

	@Override
	@ThreadSafe
	public void render(Context ctx, Appendable app, String crnt, String lvl1, String EOL) throws IOException
	{
		fact.clone().getRoot().append(app, crnt, lvl1, EOL);
	}
}