package eu.javaexperience.web.fw.template.dom;

import java.util.Collection;
import java.util.Map;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;

public class HElementTemplateManager implements TemplateManager
{
	protected final Map<String, HElementTemplate> views;
	
	public HElementTemplateManager(Map<String, HElementTemplate> views)
	{
		AssertArgument.assertNotNull(views, "views");
		this.views = views;
	}
	
	@Override
	public Template getView(String label)
	{
		return views.get(label);
	}

	@Override
	public Collection<String> getViews()
	{
		return views.keySet();
	}
}