package eu.javaexperience.web.server.binding;

import java.io.IOException;

import javax.servlet.http.HttpSession;

import eu.javaexperience.io.IOStream;
import eu.javaexperience.web.features.WebSocket;

/**
 * Combines the ServletRequest and ServeltResponses into one unit, and:
 * 	- supplies functionality where both required (WebSocket)
 * 	- contains extra information about:
 * 		- servicing state.
 * 		- socket protocol
 * 
 * 
 * */
public interface HttpQueryContext
{
	/**
	 * returns the socket, this query derivated from.
	 * Note that, don't store this socket or use to  
	 * */
	public IOStream getSocket();
	
	public HttpSocketProtocolHandler getProtocol();
	
	public HttpRequest getRequest();
	
	public HttpResponse getResponse();
	
	public long getTimeMetric(HttpServingTimeMetric metic);
	public void setTimeMetric(HttpServingTimeMetric metic, long t);
	
	/**
	 * Framework or client may signal that the request is successfully
	 * accomplished, whatever it's ended with success or exception.
	 * 
	 * Typically used by framework after request returned from the dispatching
	 * mechanism.
	 * */
	public void operationEnded();
	
	/**
	 * Client or framework may check that request is served. 
	 * */
	public boolean isOperationEnded();
	
	/**
	 * 
	 * */
	public WebSocket upgradeWebsocket() throws IOException;
	
	public void setSession(HttpSession session);
	
	public HttpSession getSession();
/*	
	//TODO
	public SocketHandler getSocketHandler();
	
	public int getResponseContentLength();
	
	public void fillHeaders(Map<String,String> forHeaders);
	
	public String getResponseHead();
	
	public String getRequestContentType();
	
	public int getRequestContentLength();
	
	//public void addAttribute(String key, Object val);

	public String getUploadTmpDir();

	public void putExtraParameter(String key, String[] value);

	public void putExtraAttribute(String string, Object data);
*/
}
