package eu.javaexperience.web.server.binding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import eu.javaexperience.io.IOStream;
import eu.javaexperience.web.server.commons.LightningOutput;

/**
 * Encapsulates the HttpQueryCreation from sockets.
 * 
 * 
 * 
 * 
 * */
public interface HttpSocketProtocolHandler
{
	public HttpSocketProtocol getProtocolInfo();
	
	/**
	 * Returns the raw backend IOStream of the connection, maybe you want to
	 * use getWrappedStream() to get the wrapped one, that you can use to send
	 * data to the client. 
	 * */
	@Deprecated
	public IOStream getRawStream();
	
	public void initRequest() throws IOException;
	
	public IOStream getWrappedStream();
	
	
	public String getHttpRequestProperty(HttpRequestProperty prop);
	
	public Map<String, String> getRequestHeaders();
	
	public Map<String, String[]> getQueryParams();
	
	public void handlePosts(HttpRequest req) throws IOException;

	public void sendResponseHeaders
	(
		LightningOutput os,
		int responseStatus,
		String responseStatusText,
		Map<String, String> send
	) throws IOException;
	
	
	public void finishTransmission(LightningOutput os) throws IOException;
	
}
