package eu.javaexperience.web.server.commons;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

import eu.javaexperience.io.AutoFlushListener;
import eu.javaexperience.io.BufferedOutput;
import eu.javaexperience.reflect.Mirror;

public class LightningOutput extends PrintWriter
{
	protected BufferedOutput buffOutput;
	
	protected LightningOutput(OutputStream backend, BufferedOutput out)
	{
		super(out);
		this.backend = backend;
		buffOutput = out;
	}
	
	protected final OutputStream backend;
	
	public static LightningOutput create(final OutputStream out, final AutoFlushListener<LightningOutput> flush)
	{
		final LightningOutput[] ptr = new LightningOutput[1];
		final LightningOutput ret = new LightningOutput(out, new BufferedOutput(out)
		{
			@Override
			protected void flushBuffer() throws IOException
			{
				if(null != flush)
				{
					flush.beforeBufferFlush(ptr[0]);
				}
				
				super.flushBuffer();
				
				if(null != flush)
				{
					flush.afterBufferFlush(ptr[0]);
				}
			}
		});
		
		ptr[0] = ret;
		
		return ret;
	}
	
	protected Object owner;
	
	public OutputStream getBackendOutput()
	{
		return backend;
	}

	public Object getOwner()
	{
		return owner;
	}

	public void setOwner(Object owner)
	{
		this.owner = owner;
	}

	public void write(byte[] b, int off, int len) throws IOException
	{
		buffOutput.write(b, off, len);
	}
	
	protected OutputStream os = new OutputStream()
	{
		@Override
		public void write(int b) throws IOException
		{
			buffOutput.write(b);
		}
		
		public void write(byte[] b) throws IOException
		{
			buffOutput.write(b);
		};
		
		@Override
		public void write(byte[] b, int off, int len) throws IOException
		{
			buffOutput.write(b, off, len);
		}
		
		@Override
		public void flush()
		{
			LightningOutput.this.flush();
		}
	};
	
	public OutputStream asOutputStream()
	{
		return os;
	}

	public void flushBuffer() throws IOException
	{
		buffOutput.flush();
	}
	
	@Override
	public void flush()
	{
		try
		{
			flushBuffer();
			super.flush();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
    public void write(char buf[], int off, int len)
    {
    	try
    	{
            out.write(buf, off, len);
        }
        catch(Exception x)
    	{
            Mirror.propagateAnyway(x);
        }
    }

    public void write(char buf[])
    {
    	write(buf, 0, buf.length);
    }

}
